//
//  SecretActionView.swift
//  PhoneManager
//
//  Created by edy on 2025/3/31.
//

import UIKit
import SnapKit

class SecretActionView: UIViewController ,UIViewControllerTransitioningDelegate {
    
    private var selectedViewBottomConstraint: Constraint?

    override func viewDidLoad() {
        super.viewDidLoad()
        view.backgroundColor = .clear//.colorWithHex(hexStr: "#000000", alpha: 0.5)
        self.transitioningDelegate = self;
        setUI()
        addTapAction()
    }
    
    func animationController(forDismissed dismissed: UIViewController) -> UIViewControllerAnimatedTransitioning? {
        return customDismissAnimator()
    }
    
    /// 添加背景点击消失
    func addTapAction(){
        self.view.isUserInteractionEnabled = true
        let tap = UITapGestureRecognizer()
        tap.addTarget(self, action: #selector(touchDismiss))
        self.view.addGestureRecognizer(tap)
    }
    
    
    private func setUI() -> Void {
        view.addSubview(backView)
        backView.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            // 初始时将 selectedView 移到屏幕下方
            self.selectedViewBottomConstraint = make.bottom.equalToSuperview().offset(1000).constraint
        }
        lineV.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(16)
            make.centerX.equalToSuperview()
            make.size.equalTo(CGSize(width: 57.RW(), height: 4))
        }
        descpLabel.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.top.equalTo(lineV.snp.bottom).offset(20)
        }
        CarmaBtn.snp.makeConstraints { make in
            make.left.right.equalToSuperview().inset(15)
            make.top.equalTo(descpLabel.snp.bottom).offset(16)
            make.height.equalTo(56)
        }
        PhotoBtn.snp.makeConstraints { make in
            make.left.right.equalToSuperview().inset(15)
            make.top.equalTo(CarmaBtn.snp.bottom).offset(16)
            make.height.equalTo(56)
        }
        
        cancelBtn.snp.makeConstraints { make in
            make.left.right.equalToSuperview().inset(15)
            make.top.equalTo(PhotoBtn.snp.bottom).offset(16)
            make.height.equalTo(56)
            make.bottom.equalToSuperview().offset(-46.RH())
        }
        view.layoutIfNeeded()
        backView.cornerCut(radius: 20, corner: [.topLeft,.topRight])
        
        
        // 先显示背景，然后延迟显示弹框
        DispatchQueue.main.asyncAfter(deadline: .now() + 0.1) {
            UIView.animate(withDuration: 0.1) {
                // 更新约束
                self.selectedViewBottomConstraint?.update(offset: 0)
                self.view.layoutIfNeeded()
            }
        }
        
    }
    
    var callback:((_ idx:Int)->Void)?
    
    @objc private func actionTouch(_ sender:UIButton) -> Void {
        
        self.dismiss(animated: true)
        guard callback != nil else {
            return
        }
        callback!(sender.tag % 0x10)
        
    }
    
    @objc private func touchDismiss(){
//        UIView.animate(withDuration: 0.2) {
//            // 更新约束
//            self.selectedViewBottomConstraint?.update(offset: 1000)
//            self.view.layoutIfNeeded()
//        }completion: { _ in
        self.dismiss(animated: true)
        guard callback != nil else {
            return
        }
        callback!(0x12)
//        }
        
    }
    
    
    func show() -> Void {
       // guard let rt = cWindow?.rootViewController else { return }
        self.modalTransitionStyle = .crossDissolve
        self.modalPresentationStyle = .overFullScreen
        
        guard let rt = UIViewController.topMostViewController() else { return }
        rt.present(self, animated: true)
    }

    private lazy var backView: UIView = {
        let back = UIView()
        back.backgroundColor = .white
        return back
    }()
    
    private lazy var lineV: UIView = {
        let l = UIView()
        l.backgroundColor = .colorWithHex(hexStr: "#D9D9D9")
        l.layer.cornerRadius = 4
        backView.addSubview(l)
        return l
    }()
    
    private lazy var descpLabel: UILabel = {
        let desc = UILabel()
        desc.text = "Choose Action"
        desc.textColor = .colorWithHex(hexStr: "#B3B3B3")
        desc.textAlignment = .center
        desc.font = UIFont.systemFont(ofSize: 14)
        backView.addSubview(desc)
        return desc
    }()
    
    
    private lazy var CarmaBtn: UIButton = {
        let carma = UIButton(type: .custom)
        carma.setImage(UIImage(named: "ic_video_secret"), for: .normal)
        carma.backgroundColor = .colorWithHex(hexStr: "#F2F6FC")
        carma.titleLabel?.font = UIFont.boldSystemFont(ofSize: 16)
        carma.contentHorizontalAlignment = .leading
        carma.layer.cornerRadius = 12
        carma.tag = 0x10;
        carma.setTitle("Take photos or videos", for: .normal)
        carma.setTitleColor(.black, for: .normal)
        carma.addTarget(self, action: #selector(actionTouch(_:)), for: .touchUpInside)
        carma.imageEdgeInsets = UIEdgeInsets(top: 0, left: 10, bottom: 0, right: 0)
        carma.titleEdgeInsets = UIEdgeInsets(top: 0, left: 20, bottom: 0, right: 0)
        backView.addSubview(carma)
        return carma
    }()
    
    private lazy var PhotoBtn: UIButton = {
        let Photo = UIButton(type: .custom)
        Photo.setImage(UIImage(named: "ic_photo_secret"), for: .normal)
        Photo.backgroundColor = .colorWithHex(hexStr: "#F2F6FC")
        Photo.titleLabel?.font = UIFont.boldSystemFont(ofSize: 16)
        Photo.contentHorizontalAlignment = .leading
        Photo.layer.cornerRadius = 12
        Photo.tag = 0x11;
        Photo.setTitle("Import photos or videos", for: .normal)
        Photo.setTitleColor(.black, for: .normal)
        Photo.addTarget(self, action: #selector(actionTouch(_:)), for: .touchUpInside)
        Photo.imageEdgeInsets = UIEdgeInsets(top: 0, left: 10, bottom: 0, right: 0)
        Photo.titleEdgeInsets = UIEdgeInsets(top: 0, left: 20, bottom: 0, right: 0)
        backView.addSubview(Photo)
        return Photo
    }()
    
    lazy var cancelBtn: UIButton = {
        let can = UIButton(type: .custom)
        can.setTitle("Cancel", for: .normal)
        can.backgroundColor = .white
        can.tag = 0x12
        can.addTarget(self, action: #selector(actionTouch(_:)), for: .touchUpInside)
        can.setTitleColor(.black, for: .normal)
        backView.addSubview(can)
        return can
    }()
    
    deinit {
        callback = nil
    }
}
