//
//  PMShowImgCell.swift
//  PhoneManager
//
//  Created by edy on 2025/4/9.
//

import UIKit

let PMShowImgCellID = "PMShowImgCell"

class PMShowImgCell: UICollectionViewCell {
    
    var callblock:(()->Void) = {}
    
    @objc private func selectTap() -> Void {
        callblock()
    }
    
    var isCurrent:Bool = false {
        didSet {
            selectBtn.isSelected = isCurrent
        }
    }
    
    var icon:UIImage = UIImage() {
        didSet {
            scaleImg.icon = icon
        }
    }
    
    var model:ImageSeletedCollectionItem?{
        didSet{
            guard let model = model else{
                return
            }
            
            scaleImg.localIdentifier = model.id?.localIdentifier
//            if let id = model.id.localIdentifier{
//                scaleImg.showImg
//            }

            
        }
    }
    
    lazy var bestResultButton:UIButton = {
       
        let button = UIButton(type: .custom)
        button.setImage(UIImage(named: "Frame"), for: .normal)
        button.setTitle("Best", for: .normal)
        button.setTitleColor(.white, for: .normal)
        button.titleLabel?.font = UIFont.systemFont(ofSize: 14, weight: .semibold)
        button.layer.cornerRadius = 10.5
        button.clipsToBounds = true
        button.backgroundColor = UIColor(red: 1, green: 0.65, blue: 0, alpha: 1)
        contentView.addSubview(button)
        return button
        
    }()

    private lazy var iconView: UIImageView = {
        let info = UIImageView()
        info.contentMode = .scaleAspectFill
        contentView.addSubview(info)
        info.clipsToBounds = true
        return info
    }()
 
    lazy var selectBtn: UIButton = {
        let select = UIButton(type: .custom)
        select.setImage(UIImage(named: "Frame_1318"), for: .normal)
        select.setImage(UIImage(named: "重复项说明-icon-选中 1"), for: .selected)
        select.addTarget(self, action: #selector(selectTap), for: .touchUpInside)
        contentView.addSubview(select)
        return select
    }()
    
    private lazy var scaleImg: PMScaleImageView = {
        let img = PMScaleImageView()
        contentView.addSubview(img)
        return img
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setup()
        backgroundColor = .clear
        clipsToBounds = true
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    private func setup() -> Void {
        
        bestResultButton.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(15)
            make.top.equalToSuperview().offset(34)
            make.width.equalTo(63)
            make.height.equalTo(21)
        }
        
        iconView.snp.makeConstraints { make in
            make.left.right.bottom.top.equalToSuperview()
        }
        scaleImg.snp.makeConstraints { make in
            make.left.right.bottom.top.equalToSuperview()
        }
        selectBtn.snp.makeConstraints { make in
            make.right.equalToSuperview().inset(25)
            make.width.height.equalTo(iconWH)
            make.bottom.equalToSuperview().offset(-10)
        }
        
        self.contentView.bringSubviewToFront(self.bestResultButton)
    }
}
