//
//  PayCompletedViewController.swift
//  PhoneManager
//
//  Created by edy on 2025/4/16.
//

import Foundation
import UIKit
class PayCompletedViewController : BaseViewController{
    

    
    lazy var logoImageView : UIImageView = {
        
        let view = UIImageView()
        view.layer.cornerRadius = 22.5
        view.clipsToBounds = true
        view.image = UIImage(named: "logo_phone_manager")
        return view
    }()
    
    lazy var titleLabel : UILabel = {
        
        let view = UILabel()
        view.text = "Phone Manager Pro Edition"
        view.textColor = UIColor(red: 0.2, green: 0.2, blue: 0.2, alpha: 1)
        view.font = UIFont.systemFont(ofSize: 18, weight: .bold)
        view.textAlignment = .center
        return view
    }()
    
    lazy var detailTitleLabel : UILabel = {
        
        let view = UILabel()
        view.text = "You can now access all Phone Manager features without restrictions"
        view.textColor = UIColor(red: 0.4, green: 0.4, blue: 0.4, alpha: 1)
        view.font = UIFont.systemFont(ofSize: 14, weight: .regular)
        view.textAlignment = .center
        view.numberOfLines = 0
        return view
    }()
    
    lazy var closeButton : UIButton = {
        let view = UIButton()
        view.backgroundColor = .clear
        view.setImage(UIImage(named: "ic_close_charging"), for: .normal)
        view.addTarget(self, action: #selector(closeCurrentPage), for: .touchUpInside)
        return view
    }()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        setUI()
    }
    
    func setUI(){
        
        self.view.addSubview(self.closeButton)
        self.view.addSubview(self.logoImageView)
        self.view.addSubview(self.titleLabel)
        self.view.addSubview(self.detailTitleLabel)
        
        self.closeButton.snp.makeConstraints { make in
            make.right.equalToSuperview().offset(-15)
            make.top.equalToSuperview().offset(statusBarHeight + 15)
            make.width.height.equalTo(28)
        }
       
        
        self.logoImageView.snp.makeConstraints { make in
            make.width.height.equalTo(150)
            make.top.equalToSuperview().offset(210)
            make.centerX.equalToSuperview()
        }
        
        self.titleLabel.snp.makeConstraints { make in
            make.top.equalTo(self.logoImageView.snp.bottom).offset(40)
            make.left.equalToSuperview().offset(30)
            make.right.equalToSuperview().offset(-30)
            make.height.equalTo(25)
        }
        
        self.detailTitleLabel.snp.makeConstraints { make in
            make.top.equalTo(self.titleLabel.snp.bottom).offset(4)
            make.left.equalToSuperview().offset(30)
            make.right.equalToSuperview().offset(-30)
            make.height.equalTo(40)
        }
        
    }
    
    
}

extension PayCompletedViewController {
    
    @objc func closeCurrentPage(){
        self.dismiss(animated: true)
    }
    
}
