//
//  HomePayDueView.swift
//  PhoneManager
//
//  Created by edy on 2025/4/27.
//

import UIKit
import StoreKit

class HomePayDueView: UIView {
    
    @IBOutlet weak var dueDay: UILabel!
    @IBOutlet weak var dueTime: UILabel!
    @IBOutlet weak var freeTime: UILabel!
    @IBOutlet weak var priceL: UILabel!
    @IBOutlet weak var saveL: UILabel!
    @IBOutlet weak var freePrice: UILabel!
    
    override func awakeFromNib() {
        super.awakeFromNib()
        
        freeTime.layer.cornerRadius = 10.5
        freeTime.layer.masksToBounds = true
        
        saveL.layer.cornerRadius = 10.5
        saveL.layer.masksToBounds = true
        
        dueDay.font = UIFont.scaledSystemFont(ofSize: 12, weight: .regular)
        
        dueTime.font = UIFont.scaledSystemFont(ofSize: 12, weight: .regular)
        
        priceL.font = UIFont.scaledSystemFont(ofSize: 16, weight: .regular)
        
        freeTime.font = UIFont.scaledSystemFont(ofSize: 12, weight: .bold)
        
        saveL.font = UIFont.scaledSystemFont(ofSize: 12, weight: .bold)
        
        freePrice.font = UIFont.scaledSystemFont(ofSize: 12, weight: .regular)

        freeTime.isHidden = false
        freePrice.isHidden = false
        saveL.isHidden = true
        
    }
    
    func reloadUI(_ type:Int,week:SKProduct?,life:SKProduct?){
        
        guard let pord = week,let pord1 = life else {
            self.isHidden = true
            return
        }
        self.isHidden = false
        if type == 0{
            // 免费试用订阅
            dueDay.text = "Due today"
            freeTime.isHidden = false
            freePrice.isHidden = false
            saveL.isHidden = true
            
            priceL.text = "\(pord.localizedPrice)"
            priceL.font = UIFont.scaledSystemFont(ofSize: 18, weight: .bold)
            
            dueTime.text = "Due" + getDateSevenDaysLater()
            
        }else{
            //永久付费
            
            dueDay.text = "One-time payment"
            dueTime.text = "Lifetime"
            freeTime.isHidden = true
            freePrice.isHidden = true
            saveL.isHidden = false
            
            priceL.text = "\(pord1.localizedPrice)"
            priceL.font = UIFont.scaledSystemFont(ofSize: 18, weight: .bold)
        }
        
    }
    
    func getDateSevenDaysLater() -> String {
        // 获取今天的日期
        let today = Date()
        
        // 创建一个日历实例
        let calendar = Calendar.current
        
        // 计算今天的7天后的日期
        if let sevenDaysLater = calendar.date(byAdding: .day, value: 7, to: today) {
            // 创建一个日期格式化器
            let dateFormatter = DateFormatter()
            dateFormatter.dateFormat = "MMMM dd, yyyy" // 设置日期格式为 "March 24, 2025"
            
            // 格式化日期并返回字符串
            return dateFormatter.string(from: sevenDaysLater)
        }
        
        return ""
    }

}
