//
//  NoAdsStackView.swift
//  PhoneManager
//
//  Created by edy on 2025/4/7.
//

import UIKit

protocol NoAdsStackDataSource: AnyObject {
    func NoAdsStactChildView(_ content:NoAdsStackView, _ idx:Int) -> UIView
}


class NoAdsStackView: UIView {
    
    var dataSource:(any NoAdsStackDataSource)?
    var numbers:Int = 0 {
        didSet{
            self.loadUi()
        }
    }
    
    private func loadUi() -> Void {
        for  i in 0..<self.numbers {
            guard let child = dataSource?.NoAdsStactChildView(self , i) as? UIView else { return }
            stack.addArrangedSubview(child)
        }
    }
    
    var spacing:CGFloat = 0 {
        didSet {
            stack.spacing = spacing
        }
    }
    
    var axis:NSLayoutConstraint.Axis = .vertical{
        didSet{
            stack.axis = axis
        }
    }
    
    var alignment:UIStackView.Alignment = .fill {
        didSet{
            stack.alignment = alignment
        }
    }
    
    var distribution:UIStackView.Distribution = .fill {
        didSet{
            stack.distribution = distribution
        }
    }
    
    private lazy var stack: UIStackView = {
        let stack = UIStackView()
        stack.backgroundColor = .clear
        stack.spacing = 8
        stack.axis = .vertical
        stack.alignment = .fill
        stack.distribution = .equalSpacing
        addSubview(stack)
        return stack
    }()
    
    convenience init(_ numbers:Int) {
        self.init(frame: CGRectZero)
        self.numbers = numbers;
        DispatchQueue.main.async {
            self.loadUi()
        }
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        backgroundColor = .clear
        stack.snp.makeConstraints { make in
            make.left.right.bottom.top.equalToSuperview()
        }
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
}
