//
//  LandingTitleAnimationView.swift
//  PhoneManager
//
//  Created by zxhy on 2025/3/20.
//

import UIKit

class LandingTitleAnimationView:UIView {
    
    private var count :Int = 0
    private var spacing :CGFloat = 0
    private var listAnimationView:[LandingTitleAnimationListView] = []
    private var currentCount:Int = 0
    var callBack: callBack<Any> = {index in}
    
    init(frame: CGRect,count:Int,spacing:CGFloat) {
        
        self.count = count
        self.spacing = spacing
        
        super.init(frame: frame)
        
        addViews()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    private func setupUI () {
        
       
    }
    
    private func addViews () {
        
        let cW:CGFloat = (self.width - CGFloat(count - 1) * spacing) / CGFloat(count)
        let cH:CGFloat = self.height
        for i in 0..<count {
            
            let subView:LandingTitleAnimationListView = LandingTitleAnimationListView(frame: CGRect(x: CGFloat(i) * (cW + spacing), y: 0, width: cW, height: cH))
            self.addSubview(subView)
            
            listAnimationView.append(subView)
        }
    }
    
    func startWithIndex(index:Int) {
        
        if index < listAnimationView.count {
            
            let subView:LandingTitleAnimationListView = listAnimationView[index]
            
            subView.startAnimation(endAnimation: {[weak self] status in
                
                guard let self else {return}
                
                if (status as? AnimationStatus == AnimationStatus.end) {
                    
                    self.callBack(index)
                }
            })
        }
        
        for (i,view) in listAnimationView.enumerated() {
            
            if (i < index) {
                
                view.changeIsEnd()
            }
        }
    }
    
}

class LandingTitleAnimationListView:UIView {
    
    private var colorView:UIView?
    
    private var allColorView:UIView?
    
    private var isEnd:Bool = false
    
    override init(frame: CGRect) {
        
        super.init(frame: frame)
        
        setupUI()
        
        addViews()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    private func setupUI () {
        
        self.backgroundColor = UIColor.colorWithHex(hexStr: "#F0F2F5")
        self.layer.cornerRadius = self.height / 2 // 圆角半径
        self.layer.masksToBounds = true
        
        self.colorView = UIView(frame: self.bounds)
        colorView?.backgroundColor = UIColor.colorWithHex(hexStr: mColor)
        colorView?.layer.cornerRadius = self.height / 2 // 圆角半径
        colorView?.layer.masksToBounds = true
        colorView?.width = 0
        
        self.allColorView = UIView(frame: self.bounds)
        allColorView?.backgroundColor = UIColor.colorWithHex(hexStr: mColor)
        allColorView?.layer.cornerRadius = self.height / 2 // 圆角半径
        allColorView?.layer.masksToBounds = true
    }
    
    private func addViews () {
        
        addSubview(colorView ?? UIView())
    }
    
    func startAnimation(endAnimation:@escaping callBack<Any> = {text in}) {
        
        UIView.animate(withDuration: 4) {[weak self] in
            
            guard let self else {return}
            
            if (!isEnd) {
                
                self.colorView?.width = self.width
            }
            
        } completion: {[weak self] Bool in
            
            guard let self else {return}
            
            if (!isEnd) {
                
                isEnd = true
                endAnimation(AnimationStatus.end)
            }
            
        }

    }
    
    func changeIsEnd() {
        
        isEnd = true
        self.addSubview(self.allColorView!)
        self.colorView?.width = self.width
    }
}
