//
//  NewGuideTwoCell.swift
//  PhoneManager
//
//  Created by edy on 2025/4/28.
//

import UIKit
import Lottie

class NewGuideTwoCell: UICollectionViewCell {

    @IBOutlet weak var photoL: UILabel!
    var sizeL:UILabel!
    
    @IBOutlet weak var subL: UILabel!
    override func awakeFromNib() {
        super.awakeFromNib()
        contentView.addSubview(animationView)
        
        animationView.snp.makeConstraints { make in
            make.width.equalTo(270)
            make.height.equalTo(27)
            make.centerX.equalToSuperview()
            make.top.equalTo(photoL.snp.bottom).offset(10)
        }
        
       
        
        sizeL = UILabel()
        let sizeValue = FileTool().formatBytes(FileTool().getStorageInfo(for: .used) ?? 0 )
        sizeL.text = "\(sizeValue) used"
        sizeL.textColor = UIColor.colorWithHex(hexStr: "#151515")
        sizeL.font = UIFont.systemFont(ofSize: 18, weight: .medium)
        contentView.addSubview(sizeL)
        sizeL.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.top.equalTo(animationView.snp.bottom).offset(5)
        }
        
        playAnimationWithDelay()
        
        addSubview(animationPhotoView)
        animationPhotoView.snp.makeConstraints { make in
            make.width.equalTo(357.RW())
            make.height.equalTo(310.RW())
            make.centerX.equalToSuperview()
            make.top.equalTo(subL.snp.bottom).offset(0)
        }
        
        animationPhotoView.play()

    }

    
    lazy var animationPhotoView : LottieAnimationView = {
        let animationView = LottieAnimationView(name: "animation_guide_1")
        animationView.loopMode = .loop
        return animationView
    }()
    
    lazy var animationView:LottieAnimationView = {
        
        let animationView = LottieAnimationView(name: "onboardingStorageLight")
        
        animationView.animationSpeed = -1.0
        animationView.layer.cornerRadius = 14
        animationView.contentMode = .scaleAspectFill
        animationView.clipsToBounds = true
        return animationView
    }()
    
    func playAnimationWithDelay() {
        // 播放动画
        animationView.play(fromProgress: 0.4, toProgress: 1, loopMode: .playOnce) {[weak self] finished in
            if finished {
                // 动画播放完成后，延迟 2 秒再重新播放
                DispatchQueue.main.asyncAfter(deadline: .now() + 2) {
                    self?.playAnimationWithDelay()
                }
            }
        }
    }
}
