//
//  LandingCollectionModel.swift
//  PhoneManager
//
//  Created by zxhy on 2025/3/20.
//

import Foundation

func loadLandingSONFromBundle() -> [LandingCollectionModel]? {
    // 获取 JSON 文件路径
    guard let path = Bundle.main.path(forResource: "LandingData", ofType: "json") else {
        print("未找到 JSON 文件")
        return nil
    }
    
    do {
        // 读取文件内容
        let data = try Data(contentsOf: URL(fileURLWithPath: path))
        
        // 解析 JSON 数据
        let decoder = JSONDecoder()
        let items = try decoder.decode([LandingCollectionModel].self, from: data)
        return items
    } catch {
        print("解析 JSON 失败：\(error)")
        return nil
    }
}

struct LandingCollectionModel:Codable {
    
    var title:String
    var tip:String
    var tipKey:String
    var animation:String
    
    enum Category: String, Codable {
        case title,tip,tipKey,animation
    }
}
