//
//  MaintainViewListCell.swift
//  PhoneManager
//
//  Created by edy on 2025/5/13.
//

import UIKit
import Kingfisher
import Photos

class MaintainViewListCell: UICollectionViewCell {

    @IBOutlet weak var converImage: UIImageView!
    @IBOutlet weak var numberL: UILabel!
    
    @IBOutlet weak var selectBtn: UIButton!
    var selectBlock:(() ->Void)?
    
    override func awakeFromNib() {
        super.awakeFromNib()
       
        
    }

    
    override func layoutSubviews() {
        super.layoutSubviews()
        
        converImage.cornerCut(radius: 12, corner: .allCorners)
        numberL.cornerCut(radius: 12, corner: [.topLeft,.bottomRight])
    }
    
    @IBAction func selectClick(_ sender: Any) {
        selectBlock?()
    }
    
    func reloadData(_ asset:[AssetModel],isSelect:Bool){
        selectBtn.isSelected = isSelect
        
        if let mediaType = asset.first?.mediaType{
            let type = mediaType == 1 ? "Photos" : "Videos"
            numberL.text = "\(asset.count)\(type)"
        }
        
        if let firstAssetId = asset.first?.localIdentifier{
//            PhotoManager.shared.getImage(localIdentifier: firstAssetId) {[weak self] image in
//                guard let weakSelf = self else { return }
//                if image != nil{
//                    weakSelf.converImage.image = image
//                }
//               
//            }
           // converImage.kf
//            let fetchResult = PHAsset.fetchAssets(withLocalIdentifiers: [firstAssetId], options: nil)
//            if let asset = fetchResult.firstObject {
//                converImage.kf.setImage(with: asset)
//            }
           
            converImage.asset.load(withLocalIdentifier: firstAssetId,placeholder: UIImage.init(named: "othermoren"))
        }
        
    }
    
}
