//
//  MaintaiDetailPicCell.swift
//  PhoneManager
//
//  Created by edy on 2025/5/14.
//

import UIKit

class MaintaiDetailPicCell: UITableViewCell {

    var selectBtn:UIButton!
    
    var selectChangeBlock:(() ->Void)?
    
    @IBOutlet weak var coverImage: UIImageView!
    
    override func awakeFromNib() {
        super.awakeFromNib()
        setUI()
    }
    
    private func setUI(){
        selectBtn = UIButton()
        selectBtn.setImage(UIImage.init(named: "icon_maintai_unselect_big"), for: .normal)
        selectBtn.setImage(UIImage.init(named: "icon_maintai_select_big"), for: .selected)
        addSubview(selectBtn)
        selectBtn.addTarget(self, action: #selector(selectChange), for: .touchUpInside)
        selectBtn.snp.makeConstraints { make in
            make.right.bottom.equalTo(0)
            make.size.equalTo(30)
        }
    }
    
    @objc func selectChange(){
        selectChangeBlock?()
    }
    
    var model:AssetModel?{
        didSet{
            guard let model = model else{
                return
            }
            
            coverImage.asset.load(withLocalIdentifier: model.localIdentifier)
            
        }
    }

    
}
