//
//  MaintaiDetailImageSmallCell.swift
//  PhoneManager
//
//  Created by edy on 2025/5/14.
//

import UIKit

class MaintaiDetailImageSmallCell: UICollectionViewCell {

    
    var selectBtn:UIButton!
    var selectChangeBlock:(() ->Void)?
    @IBOutlet weak var coverImage: UIImageView!
    
    
    override func awakeFromNib() {
        super.awakeFromNib()
        coverImage.layer.cornerRadius = 12
        coverImage.layer.masksToBounds = true
        setUI()
    }
    
    var model:AssetModel?{
        didSet{
            guard let model = model else{
                return
            }
            
            coverImage.asset.load(withLocalIdentifier: model.localIdentifier)
            
        }
    }

    
    private func setUI(){
        
        selectBtn = UIButton()
        selectBtn.setImage(UIImage.init(named: "icon_maintai_unselect_small"), for: .normal)
        selectBtn.setImage(UIImage.init(named: "icon_maintai_select_small"), for: .selected)
        selectBtn.isUserInteractionEnabled = false
        addSubview(selectBtn)
      //  selectBtn.addTarget(self, action: #selector(selectChange), for: .touchUpInside)
        selectBtn.snp.makeConstraints { make in
            make.right.bottom.equalTo(0)
            make.size.equalTo(30)
        }
    }
    
    override func layoutSubviews() {
        super.layoutSubviews()
        coverImage.layer.cornerRadius = 12
        coverImage.layer.masksToBounds = true
    }
    
    @objc func selectChange(){
       // selectChangeBlock?()
    }
    
}
