//
//  KeepListManager.swift
//  PhoneManager
//
//  Created by edy on 2025/5/16.
//

import UIKit

class KeepListManager {
    
    
    /// 获取保留列表所有数据
    /// - Returns: 所有列表数据
    static func getAllKeepListData()->[AssetModel]{
        var array : [AssetModel] = []
        // 单利中的数据
        for (key,value) in Singleton.shared.keepList {
            for item in value {
                array.append(item)
            }
        }
        
        // 数据库中的数据
        let data = GroupDatabase.shared.queryAll()
        for item in data {
            array.append(AssetModel(localIdentifier: item.localIdentifier, assetSize: item.assetSize, createDate: item.createDate, mediaType: item.mediaType))
        }
        return array
        
    }

}
