//
//  ImageCollectionCell.swift
//  PhoneManager
//
//  Created by edy on 2025/3/24.
//

import UIKit
import SnapKit

class ImageCollectionCell:UICollectionViewCell {
    
    static let identifiers = "ImageCollectionCellID"
    
    private var backImageView: UIImageView?
    
    override init(frame: CGRect) {
        
        super.init(frame: frame)
        
        setupUI()
        addViews()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    var model:ImageCollectionModel! {
        
        didSet {
            
//            DispatchQueue.global().async {[weak self] in
//                
//                guard let self else {return}
//                
//                let image = PhotoAndVideoMananger.mananger.getImageFromAssetID(id: model.asset.localIdentifier)
//                
//                DispatchQueue.main.async {[weak self] in
//                    
//                    guard let self else {return}
//                    
//                    backImageView?.image = image
//                    
//                }
//            }\
            
            backImageView?.asset.load(withLocalIdentifier: model.asset.localIdentifier,placeholder: UIImage.init(named: "othermoren"))
      
            
        }
    }
    
    func setupUI() {
        
        backImageView = UIImageView()
        
        backImageView?.isUserInteractionEnabled = true
        backImageView?.contentMode = .scaleAspectFill
        backImageView?.clipsToBounds = true
        backImageView?.layer.masksToBounds = true
        backImageView?.isUserInteractionEnabled = true
        self.backgroundColor = .clear
    }
    
    func addViews() {
        
        self.addSubview(backImageView!)
    }
    
    
    override func layoutSubviews() {
        
        super.layoutSubviews()
        
        backImageView?.snp.makeConstraints({ make in
            
            make.top.left.width.height.equalToSuperview()
        })
        
        backImageView?.layer.cornerRadius = 12
        
    }
    
}

