//
//  VideocompressionHeadView.swift
//  PhoneManager
//
//  Created by edy on 2025/5/12.
//

import UIKit

class VideocompressionHeadView: UIView {

    @IBOutlet weak var sizeL: UILabel!
    
    @IBOutlet weak var sizeW: NSLayoutConstraint!
    override func awakeFromNib() {
        super.awakeFromNib()
        layer.cornerRadius = 8
        layer.masksToBounds = true
    }
    
    func reloadData(){
        
        let totall = PhotoManager.shared.getTotalSize(source: [PhotoManager.shared.videoModels])
        
        let sizeKB : Double = Double(totall/2000)
        
        if sizeKB < 1000{
            self.sizeL.text = String(format: "%.0fKB" ,sizeKB)
        }else if sizeKB < (1000 * 1000) && sizeKB > 1000{
            self.sizeL.text = String(format: "%.0fMB" ,sizeKB/1000)
        }else{
            self.sizeL.text = String(format: "%.0fGB" ,sizeKB/(1000 * 1000))
        }
        
        
        let width = sizeL.text?.textWidthFromTextString(textHeight: 21, font: UIFont.systemFont(ofSize: 14, weight: .semibold))
        
        sizeW.constant = (width ?? 30) + 10
    }
    

}
