//
//  PhotoRemoveNavView.swift
//  PhoneManager
//
//  Created by edy on 2025/5/13.
//

import UIKit
import SnapKit

enum PhotoVideoDetailNavType {
    case dateTimeNav
    case dateAndSizeNav
}

class PhotoVideoDetailNavView: UIView {

    public var backButton:UIButton!
    
    public var sizeLbel : UILabel!
    
    public var titleLbel : UILabel!
    
    public var resetButton :UIButton!
    
    private var topConstraint: Constraint?
    
    var reSetCallBack:()->Void = {}
    
    public var showType : PhotoVideoDetailNavType = .dateTimeNav {
        didSet{
            if showType == .dateAndSizeNav {
                self.sizeLbel.isHidden = false
                self.topConstraint?.update(offset: 19 + statusBarHeight)
            }else{
                self.sizeLbel.isHidden = true
                self.topConstraint?.update(offset: 6 + statusBarHeight)
            }
        }
    }
    
    override init(frame: CGRect) {
        
        super.init(frame: frame)
        
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    private func setupUI() {
        
        backgroundColor = .white

        backButton = UIButton()
        backButton.setImage(UIImage(named: "nav_back"), for: .normal)
        backButton.addTarget(self, action: #selector(backBtnClick), for: .touchUpInside)
        self.addSubview(backButton)
        
        backButton.snp.makeConstraints { make in
            make.centerY.equalTo(navCenterY)
            make.left.equalToSuperview().offset(marginLR)
            make.width.height.equalTo(iconWH)
        }
        
        
        sizeLbel = UILabel()
        sizeLbel.textColor = UIColor(red: 0.07, green: 0.07, blue: 0.07, alpha: 1)
        sizeLbel.font = UIFont.systemFont(ofSize: 12, weight: .medium)
        self.addSubview(sizeLbel)
        
        sizeLbel.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.top.equalToSuperview().offset(statusBarHeight - 3)
            make.height.equalTo(22)
        }
        
        titleLbel = UILabel()
        titleLbel.textColor = UIColor(red: 0.07, green: 0.07, blue: 0.07, alpha: 1)
        titleLbel.font = UIFont.systemFont(ofSize: 12, weight: .medium)
        self.addSubview(titleLbel)
        
        titleLbel.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            self.topConstraint = make.top.equalToSuperview().offset(6 + statusBarHeight).constraint
            make.height.equalTo(22)
        }
        
        resetButton = UIButton()
        resetButton.setImage(UIImage(named: "Frame 3"), for: .normal)
        resetButton.addTarget(self, action: #selector(resetButtonAction), for: .touchUpInside)
        resetButton.isHidden = true
        self.addSubview(resetButton)
        
        resetButton.snp.makeConstraints { make in
            make.centerY.equalTo(navCenterY)
            make.right.equalToSuperview().offset(-marginLR)
            make.width.height.equalTo(iconWH)
        }
    }
    
    @objc private func backBtnClick() {
        self.responderViewController()?.navigationController?.popViewController(animated: true)
    }
    
    @objc private func resetButtonAction() {
        self.reSetCallBack()
    }

}
