//
//  HomeDetailDeleteView.swift
//  PhoneManager
//
//  Created by edy on 2025/5/19.
//

import UIKit

class HomeDetailDeleteView: UIView {
    
    var deleteCallBack:(()->Void) = {}
    
    lazy var deleteButton : UIButton = {
        let view = UIButton()
        view.setTitle("Delete", for: UIControl.State.normal)
        view.setTitleColor(.white, for: .normal)
        view.clipsToBounds = true
        view.layer.cornerRadius = 12
        view.titleLabel?.font = UIFont.systemFont(ofSize: 16, weight: .semibold)
        view.backgroundColor = UIColor.colorWithHex(hexStr: "#0082FF")//UIColor(red: 0.7, green: 0.7, blue: 0.7, alpha: 1)
        view.setImage(UIImage(named: "pm-home-Frame-del"), for: .normal)
        view.titleEdgeInsets = UIEdgeInsets(top: 0, left: 10, bottom: 0, right: 0)
        view.addTarget(self, action: #selector(deleteButtonAction), for: .touchUpInside)
        return view
    }()

    override init(frame: CGRect) {
        super.init(frame: frame)
        self.backgroundColor = .clear
        
        self.addSubview(self.deleteButton)
        self.deleteButton.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(16)
            make.left.equalToSuperview().offset(55)
            make.right.equalToSuperview().offset(-55)
            make.height.equalTo(45)
        }
    }
    
    @objc func deleteButtonAction(){
        self.deleteCallBack()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
}
