//
//  AnchorRotatableView.swift
//  AIClean
//
//  Created by 赵前 on 2025/5/10.
//

import Foundation
import UIKit

class AnchorRotatableView: UIView {

    var maxRotationAngle: CGFloat = .pi/12
    
    lazy var imageView: UIImageView = {
        let iv = UIImageView()
        iv.contentMode = .scaleAspectFill
        iv.clipsToBounds = true
        return iv
    }()
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupView()
    }
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
        setupView()
    }
    
    private func setupView() {
        backgroundColor = .gray
        layer.cornerRadius = 12
        clipsToBounds = true
        addSubview(imageView)
        imageView.snp.makeConstraints {
            $0.edges.equalToSuperview()
        }
    }
    
    
}
