//
//  HomeUIModel.swift
//  PhoneManager
//
//  Created by edy on 2025/5/12.
//

import Foundation


struct HomeUIModel{
    
    var allFileNumber:Int = 0
    
    var allFileSize:Double = 0
    
    var duplicatesPhotos:HomePhotosModel
    
    var similarPhotos:HomePhotosModel
    
    var videos:HomePhotosModel
    
    var similarScreenShots:HomePhotosModel
    
    var screenShots:HomePhotosModel
    
    var similarVideos:HomePhotosModel
    
    var otherPhotos:HomePhotosModel
}


class HomePhotosModel:Codable  {
    
    var folderName:String
    var allFileSize:Double
    var assets:[[AssetModel]]
    
    var originalAssets:[[AssetModel]]

    init(folderName: String, allFileSize: Double, assets: [[AssetModel]],originalAssets:[[AssetModel]] = []) {
        self.folderName = folderName
        self.allFileSize = allFileSize
        self.assets = assets
        self.originalAssets = originalAssets
    }
}


enum HomeUIEnum{
    case Dublicates,Similar,Videos,SimilarScreenshots,Screensshots,SimilarVideos,Other
    
    var title:String{
        switch self {
        case .Dublicates:
            return "Dublicates"
        case .Similar:
            return "Similar"
        case .Videos:
            return "Videos"
        case .SimilarScreenshots:
            return "Similar Screenshots"
        case .Screensshots:
            return "Screensshots"
        case .SimilarVideos:
            return "Similar Videos"
        case .Other:
            return "Other"
        }
    }
    
    var index:Int{
        switch self {
        case .Dublicates:
            return 0
        case .Similar:
            return 1
        case .Videos:
            return 0
        case .SimilarScreenshots:
            return 1
        case .Screensshots:
            return 2
        case .SimilarVideos:
            return 3
        case .Other:
            return 4
        }
    }
}
