//
//  ContactModuleView.swift
//  PhoneManager
//
//  Created by edy on 2025/4/18.
//

import Foundation
import UIKit

class ContactModuleView : UIView {
    
    // 总数据
    var dataSourceModel : ContactModuleModel?
    
    // 当前页面显示数据
    var moduleViewData : [ModuleDataModel] = []
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.text = "Contacts"
        label.font = UIFont.systemFont(ofSize: 20, weight: .bold)
        label.textColor = UIColor(red: 0.2, green: 0.2, blue: 0.2, alpha: 1)
        label.textAlignment = .left
        return label
    }()
    
    lazy var tableView: UITableView = {
        let tableView = UITableView(frame: CGRect(x: 0, y: 0, width: 0, height: 12), style: UITableView.Style.plain)
        tableView.dataSource = self
        tableView.delegate = self
        tableView.register(CustomContactModuleTableViewCell.self, forCellReuseIdentifier: "CustomContactModuleTableViewCell")
        tableView.separatorStyle = .none
        tableView.backgroundColor = .clear
        tableView.isScrollEnabled = false
        // 设置分隔线样式
        tableView.separatorStyle = .none
        tableView.showsVerticalScrollIndicator = false
        
        if #available(iOS 15.0, *) {
            tableView.sectionHeaderTopPadding = 0
        }
        
        return tableView
    }()
    
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        self.addSubview(self.titleLabel)
        self.addSubview(self.tableView)
        setupTableViewConstraints()
    }
    
    private func setupTableViewConstraints() {
        
        
        self.titleLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(15 * RScreenW())
            make.top.equalToSuperview().offset(14 * RScreenH())
            make.width.equalTo(345 * RScreenW())
            make.height.equalTo(32)
        }
        
        self.tableView.snp.makeConstraints { make in
            
            make.top.equalTo(self.titleLabel.snp.bottom).offset(18 * RScreenH())
            make.width.equalTo(345 * RScreenW())
            make.centerX.equalToSuperview()
            make.bottom.equalToSuperview().offset(-safeHeight)
        }
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
}

extension ContactModuleView:UITableViewDataSource, UITableViewDelegate {
    
    func numberOfSections(in tableView: UITableView) -> Int {
        return self.moduleViewData.count
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return 1
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "CustomContactModuleTableViewCell", for: indexPath) as! CustomContactModuleTableViewCell
        
        let titleText = self.moduleViewData[indexPath.section].titleText
        let subTitleText = self.moduleViewData[indexPath.section].subTitleText
        cell.configure(title: titleText, subtitle: subTitleText)
        return cell
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        return 74
    }
    
    // 实现 UITableViewDelegate 协议方法，设置 header 的高度
    func tableView(_ tableView: UITableView, heightForHeaderInSection section: Int) -> CGFloat {
        return section == 0 ? 0 : 12
    }
    
    // 实现 UITableViewDelegate 协议方法，返回 header 视图
    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        let headerView = UIView()
        headerView.backgroundColor = .clear
        return headerView
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        // 跳转新页面
       
        if indexPath.section == 0 {
            // 跳转重复联系人页面
            let vc : ContactsDupViewController = ContactsDupViewController()
            vc.dataSourceModel = self.dataSourceModel?.duplicates
            self.responderViewController()?.navigationController?.pushViewController(vc, animated: true)
        }
        if indexPath.section == 1 {
            // 跳转不完整联系人页面
            let vc : ContactIncompleteViewController = ContactIncompleteViewController()
            vc.dataSourceModel = self.dataSourceModel?.incompleteContacts
            self.responderViewController()?.navigationController?.pushViewController(vc, animated: true)
        }
        if indexPath.section == 2 {
            // 跳转备份页面
            let vc : ContactBackupViewController = ContactBackupViewController()
            vc.dataSourceModel = self.dataSourceModel?.backups
            vc.dataSourceAllModel = self.dataSourceModel
            self.responderViewController()?.navigationController?.pushViewController(vc, animated: true)
        }
        if indexPath.section == 3 {
            // 跳转所有联系人页面
            let vc : ContactAllViewController = ContactAllViewController()
            vc.dataSourceModel = self.dataSourceModel!.allContacts
            self.responderViewController()?.navigationController?.pushViewController(vc, animated: true)
        }
    }
    
}


class CustomContactModuleTableViewCell: UITableViewCell {
    // 主标题标签
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.font = UIFont.systemFont(ofSize: 16, weight: .bold)
        label.textColor = UIColor(red: 0.2, green: 0.2, blue: 0.2, alpha: 1)
        return label
    }()
    
    // 副标题标签
    lazy var subtitleLabel: UILabel = {
        let label = UILabel()
        label.font = UIFont.systemFont(ofSize: 14, weight: .regular)
        label.textColor =  UIColor(red: 0.4, green: 0.4, blue: 0.4, alpha: 1)
        return label
    }()
    
    // 箭头图片视图
    lazy var arrowImageView: UIImageView = {
        let imageView = UIImageView(image: UIImage(named: "icon_left_setting_grey"))
        return imageView
    }()
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
        setupConstraints()
        self.layer.cornerRadius = 12
        self.clipsToBounds = true
        self.selectionStyle = .none
        self.backgroundColor = UIColor(red: 0.95, green: 0.96, blue: 0.99, alpha: 1)
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    private func setupUI() {
        self.addSubview(titleLabel)
        self.addSubview(subtitleLabel)
        self.addSubview(arrowImageView)
    }
    
    private func setupConstraints() {
        titleLabel.snp.makeConstraints { make in
            make.top.equalToSuperview().inset(16)
            make.left.equalToSuperview().offset(16)
            make.height.equalTo(22)
            make.width.equalTo(238)
        }
        
        subtitleLabel.snp.makeConstraints { make in
            make.top.equalTo(titleLabel.snp.bottom).offset(0)
            make.left.equalToSuperview().offset(16)
            make.height.equalTo(20)
            make.width.equalTo(238)
        }
        
        arrowImageView.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.width.height.equalTo(20)
            make.right.equalToSuperview().offset(-16)
        }
    }
    
    func configure(title: String, subtitle: String) {
        titleLabel.text = title
        subtitleLabel.text = subtitle
    }
}
