//
//  ContactDefaultView.swift
//  PhoneManager
//
//  Created by edy on 2025/4/18.
//

import Foundation

class ContactDefaultView : UIView {
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.text = "Contacts"
        label.font = UIFont.systemFont(ofSize: 20, weight: .bold)
        label.textColor = UIColor(red: 0.2, green: 0.2, blue: 0.2, alpha: 1)
        label.textAlignment = .left
        return label
    }()
    
    // 懒加载图片视图
    lazy var imageView: UIImageView = {
        let imageView = UIImageView()
        imageView.image = UIImage(named: "img_contacts")
        return imageView
    }()
    
    // 懒加载第一个提示标签
    lazy var firstLabel: UILabel = {
        let label = UILabel()
        label.text = "Need Access to Start Scanning"
        label.numberOfLines = 0
        label.font = UIFont.systemFont(ofSize: 24, weight: .bold)
        label.textColor = UIColor(red: 0.2, green: 0.2, blue: 0.2, alpha: 1)
        label.textAlignment = .center
        return label
    }()
    
    // 懒加载第二个提示标签
    lazy var secondLabel: UILabel = {
        let label = UILabel()
        label.text = "Phone Manager needs access to your contacts"
        label.font = UIFont.systemFont(ofSize: 14, weight: .regular)
        label.textColor = UIColor(red: 0.4, green: 0.4, blue: 0.4, alpha: 1)
        label.textAlignment = .center
        return label
    }()
    
    // 懒加载设置按钮
    lazy var settingsButton: UIButton = {
        let button = UIButton()
        button.setTitle("Go to Settings", for: .normal)
        button.backgroundColor = UIColor(red: 0, green: 0.51, blue: 1, alpha: 1)
        button.layer.cornerRadius = 25
        button.clipsToBounds = true
        button.setTitleColor(.white, for: .normal)
        button.titleLabel?.font = UIFont.systemFont(ofSize: 16, weight: .bold)
        button.addTarget(self, action: #selector(goToSettings), for: .touchUpInside)
        return button
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        self.setupUI()
        self.setupConstraints()
    }
    
    
    private func setupUI() {
        self.addSubview(self.titleLabel)
        self.addSubview(self.imageView)
        self.addSubview(self.firstLabel)
        self.addSubview(self.secondLabel)
        self.addSubview(self.settingsButton)
    }

    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
}

extension ContactDefaultView {
    
    private func setupConstraints() {
        
        self.titleLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(15 * RScreenW())
            make.top.equalToSuperview().offset(14 * RScreenH())
            make.width.equalTo(345 * RScreenW())
            make.height.equalTo(32)
        }
        
        self.imageView.snp.makeConstraints { make in
            make.top.equalTo(self.titleLabel.snp.bottom).offset(22 * RScreenH())
            make.width.height.equalTo(242 * RScreenW())
            make.centerX.equalToSuperview()
        }
        
        self.firstLabel.snp.makeConstraints { make in
            make.top.equalTo(self.imageView.snp.bottom).offset(0)
            make.width.equalTo(315 * RScreenW())
            make.height.equalTo(68)
            make.centerX.equalToSuperview()
        }
        
        self.secondLabel.snp.makeConstraints { make in
            make.top.equalTo(self.firstLabel.snp.bottom).offset(8 * RScreenH())
            make.width.equalTo(315 * RScreenW())
            make.height.equalTo(20)
            make.centerX.equalToSuperview()
        }
        
        self.settingsButton.snp.makeConstraints { make in
            make.top.equalTo(self.secondLabel.snp.bottom).offset(32 * RScreenH())
            make.width.equalTo(315 * RScreenW())
            make.height.equalTo(50)
            make.centerX.equalToSuperview()
        }
    }
    
    @objc private func goToSettings() {
        if let settingsURL = URL(string: UIApplication.openSettingsURLString) {
            UIApplication.shared.open(settingsURL, options: [:], completionHandler: nil)
        }
    }
}
