//
//  ContactNoDupPreView.swift
//  PhoneManager
//
//  Created by edy on 2025/5/8.
//

import Foundation
import UIKit

class ContactNoDupPreView : UIView {
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.text = "Duplicates"
        label.font = UIFont.systemFont(ofSize: 20, weight: .bold)
        label.textColor = UIColor(red: 0.2, green: 0.2, blue: 0.2, alpha: 1)
        label.textAlignment = .left
        return label
    }()
    
    lazy var subTitleLabel: UILabel = {
        let label = UILabel()
        label.text = "0 Contacts"
        label.font = UIFont.systemFont(ofSize: 14, weight: .regular)
        label.textColor = UIColor(red: 0.2, green: 0.2, blue: 0.2, alpha: 1)
        label.textAlignment = .left
        return label
    }()
    
    lazy var tipLabel: UILabel = {
        let label = UILabel()
        label.text = "No Preview Available"
        label.font = UIFont.systemFont(ofSize: 24, weight: .bold)
        label.textColor = UIColor(red: 0.2, green: 0.2, blue: 0.2, alpha: 1)
        label.textAlignment = .center
        return label
    }()
    
    lazy var subTipLabel: UILabel = {
        let label = UILabel()
        label.text = "Go back and select duplicate contacts to see a preview"
        label.font = UIFont.systemFont(ofSize: 14, weight: .regular)
        label.textColor = UIColor(red: 0.4, green: 0.4, blue: 0.4, alpha: 1)
        label.numberOfLines = 0
        label.textAlignment = .center
        return label
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        self.addSubview(self.titleLabel)
        self.addSubview(self.subTitleLabel)
        self.addSubview(self.tipLabel)
        self.addSubview(self.subTipLabel)
        
        self.titleLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(15 * RScreenW())
            make.top.equalToSuperview().offset(14 * RScreenH())
            make.width.equalTo(345 * RScreenW())
            make.height.equalTo(32)
        }
        
        self.subTitleLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(15 * RScreenW())
            make.top.equalTo(self.titleLabel.snp.bottom).offset(2 * RScreenH())
            make.width.equalTo(345 * RScreenW())
            make.height.equalTo(20)
        }
        
        self.tipLabel.snp.makeConstraints { make in
            make.top.equalTo(self.subTitleLabel.snp.bottom).offset(218 * RScreenH())
            make.width.equalTo(315 * RScreenW())
            make.height.equalTo(34)
            make.centerX.equalToSuperview()
        }
        self.subTipLabel.snp.makeConstraints { make in
            make.top.equalTo(self.tipLabel.snp.bottom).offset(8 * RScreenH())
            make.width.equalTo(315 * RScreenW())
            make.height.equalTo(40)
            make.centerX.equalToSuperview()
        }
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
}

