//
//  ContactBacRestoreAlertView.swift
//  PhoneManager
//
//  Created by 赵前 on 2025/4/20.
//

import Foundation

class ContactBacRestoreAlertView : UIView {
    var sureCallBack: ()->Void = {}
    
    // 懒加载背景视图
    private lazy var backgroundView: UIView = {
        let view = UIView()
        view.backgroundColor = UIColor(red: 1, green: 1, blue: 1, alpha: 0.4000)
        return view
    }()
    
    // 懒加载卡片视图
    private lazy var cardView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        view.layer.cornerRadius = 10
        view.clipsToBounds = true
        return view
    }()
    
    // 懒加载标题标签
    private lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.text = "Are you sure?"
        label.font = UIFont.systemFont(ofSize: 17, weight: .bold)
        label.textColor = UIColor(red: 0, green: 0, blue: 0, alpha: 1)
        label.textAlignment = .center
        return label
    }()
    
    // 懒加载副标题标签
    private lazy var subtitleLabel: UILabel = {
        let label = UILabel()
        label.text = "Your contacts will be removed from your iPhone and iCloud. This process cannot be reversed"
        label.font = UIFont.systemFont(ofSize: 13, weight: .regular)
        label.textColor = UIColor(red: 0, green: 0, blue: 0, alpha: 1)
        label.numberOfLines = 0
        label.textAlignment = .center
        return label
    }()
    
    // 懒加载取消按钮
    private lazy var cancelButton: UIButton = {
        let button = UIButton()
        button.setTitle("Cancel", for: .normal)
        button.backgroundColor = .clear
        button.setTitleColor(UIColor(red: 0, green: 0.48, blue: 1, alpha: 1), for: .normal)
        button.layer.cornerRadius = 5
        button.titleLabel?.font = UIFont.systemFont(ofSize: 17, weight: .regular)
        button.addTarget(self, action: #selector(dismissAlert), for: .touchUpInside)
        return button
    }()
    
    // 懒加载确认按钮
    private lazy var yesButton: UIButton = {
        let button = UIButton()
        button.setTitle("Yes", for: .normal)
        button.backgroundColor = .clear
        button.setTitleColor(UIColor(red: 0, green: 0.48, blue: 1, alpha: 1), for: .normal)
        button.layer.cornerRadius = 5
        button.titleLabel?.font = UIFont.systemFont(ofSize: 17, weight: .regular)
        button.addTarget(self, action: #selector(sureAlert), for: .touchUpInside)
        return button
    }()
    
    // 懒加载顶部边线
    private lazy var topBorder: UIView = {
        let view = UIView()
        view.backgroundColor = UIColor(red: 0.24, green: 0.24, blue: 0.26, alpha: 0.3600)
        return view
    }()
    
    // 懒加载中间分割线
    private lazy var middleBorder: UIView = {
        let view = UIView()
        view.backgroundColor = UIColor(red: 0.24, green: 0.24, blue: 0.26, alpha: 0.3600)
        return view
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        self.backgroundColor = UIColor(red: 0, green: 0, blue: 0, alpha: 0.5000)
        setupViews()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    private func setupViews() {
        self.addSubview(backgroundView)
        backgroundView.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        self.addSubview(cardView)
        cardView.snp.makeConstraints { make in
            make.center.equalToSuperview()
            make.width.equalTo(270)
            make.height.equalTo(154)
        }
        
        cardView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(16)
            make.left.right.equalToSuperview().inset(16)
            make.height.equalTo(22)
        }
        
        cardView.addSubview(subtitleLabel)
        subtitleLabel.snp.makeConstraints { make in
            make.top.equalTo(titleLabel.snp.bottom).offset(2)
            make.left.right.equalToSuperview().inset(16)
            make.height.equalTo(54)
        }
        
        cardView.addSubview(cancelButton)
        cancelButton.snp.makeConstraints { make in
            make.left.equalToSuperview()
            make.bottom.equalToSuperview()
            make.width.equalTo(cardView.snp.width).multipliedBy(0.5)
            make.height.equalTo(44)
        }
        
        cardView.addSubview(yesButton)
        yesButton.snp.makeConstraints { make in
            make.right.equalToSuperview()
            make.bottom.equalToSuperview()
            make.width.equalTo(cardView.snp.width).multipliedBy(0.5)
            make.height.equalTo(44)
        }
        
        cardView.addSubview(topBorder)
        topBorder.snp.makeConstraints { make in
            make.top.equalTo(cancelButton.snp.top)
            make.left.right.equalTo(cardView)
            make.height.equalTo(0.5)
        }
        
        cardView.addSubview(middleBorder)
        middleBorder.snp.makeConstraints { make in
            make.centerX.equalTo(cardView)
            make.top.equalTo(cancelButton.snp.top)
            make.bottom.equalTo(cancelButton.snp.bottom)
            make.width.equalTo(0.5)
        }
    }
    
    @objc private func dismissAlert() {
        self.removeFromSuperview()
    }
    
    @objc private func sureAlert() {
        self.removeFromSuperview()
        sureCallBack()
    }
}
