//
//  BaseAlertView.swift
//  PhoneManager
//
//  Created by edy on 2025/5/9.
//

import Foundation
import SnapKit

class BaseAlertView : UIView {
    
    private var bottomConstraint: Constraint?
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        
        // 先显示背景，然后延迟显示弹框
        DispatchQueue.main.asyncAfter(deadline: .now() + 0.1) {
            UIView.animate(withDuration: 0.1) {
                // 更新约束
                self.bottomConstraint?.update(offset: 0)
                self.layoutIfNeeded()
            }
        }
    }
    
    override func removeFromSuperview() {
        UIView.animate(withDuration: 0.2) {
            // 更新约束
            self.backgroundColor = .clear
            self.bottomConstraint?.update(offset: self.height)
            self.layoutIfNeeded()
        }completion: { _ in
            super.removeFromSuperview()
        }
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
}
