//
//  CustomContactBacDetailTableViewCell.swift
//  PhoneManager
//
//  Created by 赵前 on 2025/4/20.
//

import Foundation
import UIKit

class CustomContactBacDetailTableViewCell : UITableViewCell {
    var model : ContactModel?
    
    lazy var backView :  UIView = {
        let view = UIView()
        view.backgroundColor = UIColor(red: 0.95, green: 0.96, blue: 0.99, alpha: 1)
        view.clipsToBounds = true
        view.layer.cornerRadius = 12
        return view
    }()
    
    
    lazy var nameLabel :  UILabel = {
        let label = UILabel()
        label.textColor = UIColor(red: 0.2, green: 0.2, blue: 0.2, alpha: 1)
        label.font = UIFont.systemFont(ofSize: 16, weight: .bold)
        return label
    }()
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        
        
        self.selectionStyle = .none
        
        self.contentView.addSubview(self.backView)
        self.backView.addSubview(self.nameLabel)
        
        self.backView.snp.makeConstraints { make in
            make.left.right.top.equalToSuperview()
            make.height.equalTo(71)
        }
        self.nameLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(16 * RScreenH())
            make.centerY.equalToSuperview()
            make.width.equalTo(210)
            make.height.equalTo(22)
        }
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
}
