//
//  CustomContactAllViewTableViewCell.swift
//  PhoneManager
//
//  Created by 赵前 on 2025/4/19.
//

import Foundation
import UIKit
class CustomContactAllViewTableViewCell : UITableViewCell {
    
    var model : ContactModel?
    
    var buttonSelectCallBack : (ContactModel,Bool)->Void = {model,selected in}
    
    lazy var backView :  UIView = {
        let view = UIView()
        view.backgroundColor = UIColor(red: 0.95, green: 0.96, blue: 0.99, alpha: 1)
        view.clipsToBounds = true
        view.layer.cornerRadius = 12
        return view
    }()
    
    
    lazy var nameLabel :  UILabel = {
        let label = UILabel()
        label.textColor = UIColor(red: 0.2, green: 0.2, blue: 0.2, alpha: 1)
        label.font = UIFont.systemFont(ofSize: 16, weight: .bold)
        return label
    }()
    
    lazy var selectButton : UIButton = {
        let button = UIButton(type: .custom)
        button.setImage(UIImage(named: "ic_sel_com"), for: .normal)
        button.setImage(UIImage(named: "ic_unsel_com_red"), for: .selected)
        button.addTarget(self, action: #selector(selectContact(_:)), for: .touchUpInside)
        return button
    }()
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        
        
        self.selectionStyle = .none
        
        self.contentView.addSubview(self.backView)
        self.backView.addSubview(self.nameLabel)
        self.backView.addSubview(self.selectButton)
        
        self.backView.snp.makeConstraints { make in
            make.left.right.top.equalToSuperview()
            make.height.equalTo(71)
        }
        self.nameLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(16 * RScreenH())
            make.centerY.equalToSuperview()
            make.width.equalTo(210)
            make.height.equalTo(22)
        }
        
        self.selectButton.snp.makeConstraints { make in
            make.width.height.equalTo(24)
            make.centerY.equalToSuperview()
            make.right.equalToSuperview().offset(-16 * RScreenW())
        }
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
}

extension CustomContactAllViewTableViewCell {
    @objc func selectContact(_ sender: UIButton) {
        sender.isSelected = !sender.isSelected
        buttonSelectCallBack(model!,sender.isSelected)
    }
}
