//
//  ContactNoBackUpView.swift
//  PhoneManager
//
//  Created by 赵前 on 2025/4/19.
//

import Foundation
import UIKit
class ContactNoBackUpView : UIView {
    
    var newBackupCallback : ()->Void = {}
    
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.text = "Backups"
        label.font = UIFont.systemFont(ofSize: 20, weight: .bold)
        label.textColor = UIColor(red: 0.2, green: 0.2, blue: 0.2, alpha: 1)
        label.textAlignment = .left
        return label
    }()
    
    lazy var imageView: UIImageView = {
        let imageView = UIImageView()
        imageView.image = UIImage(named: "btn_add_contact")
        imageView.isUserInteractionEnabled = true
        
        let tap = UITapGestureRecognizer()
        tap.addTarget(self, action: #selector(newBackup))
        imageView.addGestureRecognizer(tap)
        
        return imageView
    }()
    
    
    lazy var tipLabel: UILabel = {
        let label = UILabel()
        label.text = "No Backup"
        label.font = UIFont.systemFont(ofSize: 24, weight: .bold)
        label.textColor = UIColor(red: 0.2, green: 0.2, blue: 0.2, alpha: 1)
        label.textAlignment = .center
        return label
    }()
    
    lazy var subTipLabel: UILabel = {
        let label = UILabel()
        label.text = "You can back up your contacts."
        label.font = UIFont.systemFont(ofSize: 14, weight: .regular)
        label.textColor = UIColor(red: 0.4, green: 0.4, blue: 0.4, alpha: 1)
        label.textAlignment = .center
        return label
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        self.addSubview(self.titleLabel)
        self.addSubview(self.imageView)
        self.addSubview(self.tipLabel)
        self.addSubview(self.subTipLabel)
        
        self.titleLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(15 * RScreenW())
            make.top.equalToSuperview().offset(14 * RScreenH())
            make.width.equalTo(345 * RScreenW())
            make.height.equalTo(32)
        }
        
        self.imageView.snp.makeConstraints { make in
            make.top.equalTo(self.titleLabel.snp.bottom).offset(170 * RScreenH())
            make.width.height.equalTo(58)
            make.centerX.equalToSuperview()
        }
        
        self.tipLabel.snp.makeConstraints { make in
            make.top.equalTo(self.imageView.snp.bottom).offset(12 * RScreenH())
            make.width.equalTo(315 * RScreenW())
            make.height.equalTo(34)
            make.centerX.equalToSuperview()
        }
        self.subTipLabel.snp.makeConstraints { make in
            make.top.equalTo(self.tipLabel.snp.bottom).offset(8 * RScreenH())
            make.width.equalTo(315 * RScreenW())
            make.height.equalTo(20)
            make.centerX.equalToSuperview()
        }
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    
}

extension ContactNoBackUpView {
    
    
    @objc func newBackup() {
        self.newBackupCallback()
    }
}
