//
//  VideoPlayView.swift
//  PhoneManager
//
//  Created by edy on 2025/5/15.
//

import UIKit

class VideoPlayView: UIView {
    
    lazy var playImageView : UIImageView = {
        let imageView = UIImageView()
        imageView.backgroundColor = .clear
        imageView.image = UIImage(named: "playImage")
        return imageView
    }()
    
    lazy var timeLabel : UILabel = {
        let label = UILabel()
        label.textColor = .white
        label.text = "00:25"
        label.font = UIFont.systemFont(ofSize: 14, weight: .semibold)
        label.textAlignment = .right
        return label
    }()
    
    
    lazy var videoView : UIImageView = {
        let view = UIImageView()
        view.clipsToBounds = true
        view.layer.cornerRadius = 12
        view.contentMode = .scaleAspectFit
        view.backgroundColor = .clear
        return view
    }()

    override init(frame: CGRect) {
        super.init(frame: frame)
        
        self.addSubview(self.videoView)
        self.videoView.snp.makeConstraints { make in
            make.left.top.right.bottom.equalToSuperview()
        }
        
        self.addSubview(self.timeLabel)
        self.timeLabel.snp.makeConstraints { make in
            make.right.equalToSuperview().offset(-8)
            make.top.equalToSuperview().offset(8)
            make.height.equalTo(20)
        }
        
        
        self.addSubview(self.playImageView)
        self.playImageView.snp.makeConstraints { make in
            make.width.height.equalTo(18)
            make.center.equalToSuperview()
        }
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    

}
