//
//  CompressingViewController.swift
//  PhoneManager
//
//  Created by edy on 2025/4/2.
//

import Foundation

class CompressingView: UIView{
    
    
    var  data: AssetModel?
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    lazy var backView:UIView = {
        let view = UIView()
        view.backgroundColor = UIColor(red: 0, green: 0.51, blue: 1, alpha: 1)
        return view
    }()
    
    lazy var animationView:CircularProgressBar = {
        let progressBar = CircularProgressBar()
        progressBar.progressColor = UIColor.white
        progressBar.trackColor = UIColor.colorWithHex(hexStr: "#2B85FF")
        progressBar.lineWidth = 20
        return progressBar
    }()
    lazy var tipLabel:UILabel = {
        let view = UILabel()
        view.text = "We're freeing up space on your device."
        view.textAlignment = .center
        view.textColor = UIColor(red: 1, green: 1, blue: 1, alpha: 1)
        return view
    }()
    
    func setUI(){
        self.addSubview(self.backView)
        self.addSubview(self.animationView)
        self.addSubview(self.tipLabel)
        self.backView.snp.makeConstraints { make in
            make.top.bottom.left.right.equalToSuperview()
        }
        
        self.animationView.snp.makeConstraints { make in
            make.width.height.equalTo(180)
            make.centerX.equalToSuperview()
            make.top.equalToSuperview().offset(156)
        }
        
        self.tipLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(15)
            make.right.equalToSuperview().offset(-15)
            make.centerX.equalToSuperview()
            make.top.equalTo(self.animationView.snp.bottom).offset(95)
        }
    }
    
}
