//
//  CompressNavView.swift
//  PhoneManager
//
//  Created by edy on 2025/4/2.
//

import Foundation

class CompressNavView : UIView {
    private var backButton:UIButton!
    private var titleLabel:UILabel!
    private var proBtn:UIButton!
    
    override init(frame: CGRect) {
        
        super.init(frame: frame)
        
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    private func setupUI() {
        
        backgroundColor = .white

        backButton = UIButton()
        backButton.setImage(UIImage(named: "nav_back"), for: .normal)
        backButton.addTarget(self, action: #selector(backBtnClick), for: .touchUpInside)
        self.addSubview(backButton)
        
        backButton.snp.makeConstraints { make in
            
            make.centerY.equalTo(navCenterY)
            make.left.equalToSuperview().offset(marginLR)
            make.width.height.equalTo(iconWH)
        }
        
        titleLabel = UILabel()
        titleLabel.text = "Compress"
        titleLabel.font = UIFont.systemFont(ofSize: 20, weight: .bold)
        titleLabel.textColor = UIColor(red: 0.2, green: 0.2, blue: 0.2, alpha: 1)
        titleLabel.textAlignment = .center
        self.addSubview(titleLabel)
        
        proBtn = UIButton(frame: CGRect(x: 0, y: 0, width: 70, height: iconWH))
        proBtn.setBackgroundImage(UIImage(named: "ic_pro_home"), for: .normal)
        proBtn.addTarget(self, action: #selector(proBtnClick), for: .touchUpInside)
        self.addSubview(proBtn)
        
        titleLabel.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.centerY.equalTo(navCenterY)
            make.width.equalTo(100)
            make.height.equalTo(28)
        }
        
        
        proBtn.snp.makeConstraints { make in
            make.centerY.equalTo(navCenterY)
            make.right.equalToSuperview().offset(-15)
            make.width.equalTo(70)
            make.height.equalTo(iconWH)
        }
        
    }
    
    @objc private func backBtnClick() {
        self.responderViewController()?.navigationController?.popViewController(animated: true)
    }
    
    @objc private func proBtnClick() {
        if IAPManager.share.isSubscribed == false {
            HomePayViewController.show {}
        }else {
            let vc : PayCompletedViewController =  PayCompletedViewController()
            vc.modalPresentationStyle = .fullScreen
            self.responderViewController()?.present(vc, animated: true)
        }
        
    }
    
    
}
