//
//  PreViewController.swift
//  PhoneManager
//
//  Created by 赵前 on 2025/4/6.
//

import Foundation
class PreViewController : BaseViewController {
    
    var dataSource : [String] = []

    var imageIdent : String = ""
    
    lazy var preImageView : UIImageView = {
        let view = UIImageView(frame: CGRect(x: 0, y: self.titleView.height, width: self.view.width, height: self.view.height - self.titleView.height))
        view.backgroundColor = .white
        view.image = PhotoManager.shared.getImageFromAssetID(id: self.imageIdent)
        view.contentMode = .scaleAspectFit
        view.clipsToBounds = true
        
        view.isUserInteractionEnabled = true
        let tap = UITapGestureRecognizer()
        tap.addTarget(self, action: #selector(selectClick))
        view.addGestureRecognizer(tap)
        
        return view
    }()
    
    
    @objc func selectClick(){
        self.navigationController?.popViewController(animated: true)
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        self.view.addSubview(self.preImageView)
    }
}
