//
//  CompressQualityController.swift
//  PhoneManager
//
//  Created by edy on 2025/4/2.
//

import Foundation


/// 压缩多少枚举
enum CompressQualityType : Double {
    // 压缩少量
    case low = 0.8
    // 压缩中等
    case mid = 0.5
    // 压缩较多
    case high = 0.2
}

class CompressQualityController : BaseViewController{
    
    var model : AssetModel?
    
    
    var currentQulityType : CompressQualityType = .low
    
    var currentMediaType : CompressType = .compressPhoto {
        didSet{
            self.imageView.isHidden = currentMediaType == .compressVideo
            self.videoView.isHidden = currentMediaType == .compressPhoto
        }
    }
    
    private var compressNav:CompressNavView?
    
    
    
    lazy var videoView : VideoPlayView = {
        let view = VideoPlayView()
        view.clipsToBounds = true
        view.layer.cornerRadius = 12
        view.backgroundColor = .clear
        return view
    }()
    
    lazy var imageView: UIImageView = {
        let imageView = UIImageView()
        imageView.clipsToBounds = true
        imageView.layer.cornerRadius = 12
        imageView.contentMode = .scaleAspectFit
        imageView.backgroundColor = .clear
        imageView.image = UIImage(named: "img_compress")
        return imageView
    }()
    
    
    lazy var tipLabel: UILabel = {
        let label = UILabel()
        label.text = "Select photo quality after compression"
        label.textAlignment = .left
        label.font = UIFont.systemFont(ofSize: 16, weight: .bold)
        label.backgroundColor = .clear
        return label
    }()
    lazy var lowQualityView: QualityView = {
        let view = QualityView()
        view.type = 0
        view.selectedImageView.image = UIImage(named: "ic_unsel_com")
        view.layer.borderWidth = 1
        return view
    }()
    
    lazy var mediumQualityView: QualityView = {
        let view = QualityView()
        view.type = 1
        view.tipLabel.text = "Medium quality"
        view.detailTiplabel.text = "Compress up to 50% of the size"
        return view
    }()
    
    lazy var highQualityView: QualityView = {
        let view = QualityView()
        view.type = 2
        view.tipLabel.text = "High quality"
        view.detailTiplabel.text = "Compress up to 20% of the size"
        return view
    }()
    
    
    
    lazy var buttonBacView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        view.addTopShadow()
        return view
    }()
    
    lazy var submitButton : UIButton = {
        let view = UIButton()
        view.setTitle("Compress", for: UIControl.State.normal)
        view.setTitleColor(UIColor(red: 1, green: 1, blue: 1, alpha: 1), for: .normal)
        view.clipsToBounds = true
        view.layer.cornerRadius = 23
        view.backgroundColor = UIColor(red: 0, green: 0.51, blue: 1, alpha: 1)
        view.addTarget(self, action: #selector(submitAction), for: .touchUpInside)
        return view
    }()
    
    
    func setUI(){
        compressNav = CompressNavView(frame: CGRect(x: 0, y: 0, width: self.view.width, height: statusBarHeight + 44))
        self.view.addSubview(compressNav!)
        compressNav?.snp.makeConstraints({ make in
            make.top.centerX.width.equalToSuperview()
            make.height.equalTo(statusBarHeight + 44)
        })
        self.view.addSubview(self.videoView)
        self.view.addSubview(self.imageView)
        self.view.addSubview(self.tipLabel)
        self.view.addSubview(self.lowQualityView)
        self.view.addSubview(self.mediumQualityView)
        self.view.addSubview(self.highQualityView)
        self.view.addSubview(self.buttonBacView)
        self.buttonBacView.addSubview(self.submitButton)
        
        self.imageView.snp.makeConstraints { make in
            make.top.equalTo(self.compressNav!.height + 20)
            make.left.equalToSuperview().offset(15)
            make.right.equalToSuperview().offset(-15)
            make.height.equalTo(267 * ((self.view.width - 30) / 345))
        }
        self.videoView.snp.makeConstraints { make in
            make.top.equalTo(self.compressNav!.height + 20)
            make.left.equalToSuperview().offset(15)
            make.right.equalToSuperview().offset(-15)
            make.height.equalTo(267 * ((self.view.width - 30) / 345))
        }
        
        self.tipLabel.snp.makeConstraints { make in
            make.top.equalTo(self.imageView.snp.bottom).offset(20)
            make.left.equalToSuperview().offset(15)
            make.right.equalToSuperview().offset(-15)
            make.height.equalTo(22)
        }
        self.lowQualityView.snp.makeConstraints { make in
            make.top.equalTo(self.tipLabel.snp.bottom).offset(16)
            make.left.equalToSuperview().offset(15)
            make.right.equalToSuperview().offset(-15)
            make.height.equalTo(61)
        }
        self.mediumQualityView.snp.makeConstraints { make in
            make.top.equalTo(self.lowQualityView.snp.bottom).offset(12)
            make.left.equalToSuperview().offset(15)
            make.right.equalToSuperview().offset(-15)
            make.height.equalTo(61)
        }
        self.highQualityView.snp.makeConstraints { make in
            make.top.equalTo(self.mediumQualityView.snp.bottom).offset(12)
            make.left.equalToSuperview().offset(15)
            make.right.equalToSuperview().offset(-15)
            make.height.equalTo(61)
        }
        
        
        self.buttonBacView.snp.makeConstraints { make in
            make.bottom.equalTo(-safeHeight)
            make.left.equalToSuperview()
            make.right.equalToSuperview()
            make.height.equalTo(68)
        }
        
        self.submitButton.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(15)
            make.right.equalToSuperview().offset(-15)
            make.height.equalTo(46)
            make.centerY.equalToSuperview()
        }
        
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        view.backgroundColor = .white
        self.navigationController?.navigationBar.isHidden = true
        
        setUI()
        
        self.lowQualityView.callBack = {[weak self] type in
            guard let self else {return}
            self.currentQulityType = .low
            self.lowQualityView.selectedImageView.image = UIImage(named: "ic_unsel_com")
            self.lowQualityView.layer.borderWidth = 1
            self.mediumQualityView.layer.borderWidth = 0
            self.highQualityView.layer.borderWidth = 0
            self.mediumQualityView.selectedImageView.image = UIImage(named: "ic_sel_com")
            self.highQualityView.selectedImageView.image = UIImage(named: "ic_sel_com")
            setButtonTitleByType(type: .low)
            setImageByType(type: .low)
            self.vibrate()
        }
        
        self.mediumQualityView.callBack = {[weak self] type in
            guard let self else {return}
            self.currentQulityType = .mid
            self.lowQualityView.selectedImageView.image = UIImage(named: "ic_sel_com")
            self.lowQualityView.layer.borderWidth = 0
            self.mediumQualityView.layer.borderWidth = 1
            self.highQualityView.layer.borderWidth = 0
            self.mediumQualityView.selectedImageView.image = UIImage(named: "ic_unsel_com")
            self.highQualityView.selectedImageView.image = UIImage(named: "ic_sel_com")
            setButtonTitleByType(type: .mid)
            setImageByType(type: .mid)
            self.vibrate()
        }
        
        self.highQualityView.callBack = {[weak self] type in
            guard let self else {return}
            self.currentQulityType = .high
            self.lowQualityView.selectedImageView.image = UIImage(named: "ic_sel_com")
            self.lowQualityView.layer.borderWidth = 0
            self.mediumQualityView.layer.borderWidth = 0
            self.highQualityView.layer.borderWidth = 1
            self.mediumQualityView.selectedImageView.image = UIImage(named: "ic_sel_com")
            self.highQualityView.selectedImageView.image = UIImage(named: "ic_unsel_com")
            setButtonTitleByType(type: .high)
            setImageByType(type: .high)
            self.vibrate()
        }
        
        
        // 设置默认值
        setButtonTitleByType(type: .low)
        setImageByType(type: .low)
       
    }
    
    func setButtonTitleByType(type : CompressQualityType){
        let size : Double = model?.assetSize ?? 0.0
        let compressSize : Double = size * (1 - type.rawValue)
        // 设置按钮内容将要压缩的大小
        self.submitButton.setTitle("Compress \(formatFileSize(compressSize))", for: .normal)
    }
    
    func setImageByType(type : CompressQualityType){
        if type == .low {
            self.imageView.image = UIImage(named: "img_compress")
            self.videoView.videoView.image = UIImage(named: "img_compress 3")
        }else if type == .mid {
            self.imageView.image = UIImage(named: "img_compress 1")
            self.videoView.videoView.image = UIImage(named: "img_compress 4")
        }else {
            self.imageView.image = UIImage(named: "img_compress 2")
            self.videoView.videoView.image = UIImage(named: "img_compress 5")
        }
    }
    
    
    
    fileprivate func updateNextView(_ compressAllSize: Double, _ compressingView: CompressingView,_ comDataSource : [Data],_ comVideoDataSource : [URL]) {
        DispatchQueue.main.async {
            compressingView.removeFromSuperview()
            let vc = CompressCompletedViewController()
            vc.currentMediaType = self.currentMediaType
            vc.comDataSource = comDataSource
            vc.comVideoDataSource = comVideoDataSource
            vc.model = self.model
            self.navigationController?.pushViewController(vc, animated: true)
        }
    }
    
    @objc func submitAction(){
        
        // 如果没有不进行下一步操作
        if IAPManager.share.isSubscribed == false {
            HomePayViewController.show {
                if IAPManager.share.isSubscribed == false{
                    // 弹出提示框
                    self.view.showBlur()
                    var frame = self.view.bounds
                    frame.origin.y = frame.height
                    let alertView = AdvTipSelectView()
                    alertView.selectType = .selectTypeCompressPhoto
                    alertView.getOtherInfoByType()
                    alertView.modalPresentationStyle = .overFullScreen
                    self.present(alertView, animated: true)
                    alertView.selectClickCallback = {isSure in
                        self.view.hideBlur()
                        alertView.dismiss(animated: true) {
                            if isSure {
                                self.popAdverTisement()
//                                AdvManager.shared.finisedCallBack = {
//                                    self.jumpToNextPage()
//                                }
//                                AdvManager.shared.failueFinishedCallBack = {
//                                    self.navigationController?.popViewController(animated: true)
//                                }
                            }
                        }
                    }
                }else {
                    self.jumpToNextPage()
                }
                
            }
        }else {
            self.jumpToNextPage()
        }
    }
    
    func jumpToNextPage(){
        // 跳转进度页面
        let vc : CompressingViewController = CompressingViewController()
        vc.model = self.model
        vc.qualityType = self.currentQulityType
        vc.currentMediaType = self.currentMediaType
        self.navigationController?.pushViewController(vc, animated: true)
    }
    /// 弹出广告
    func popAdverTisement(){
       // AdvManager.shared.showRewardedInterstitialAd(vc: self,from:"compress")
        
        ADManager.shared.showRewardedInterstitialAd(from:ADShowTypeEnum.Compress.name) {
            self.jumpToNextPage()
        } showFailBlock: { error in
            self.navigationController?.popViewController(animated: true)
        }
    }
}

