//
//  CompressSortCell.swift
//  PhoneManager
//
//  Created by edy on 2025/4/3.
//

import Foundation

class CompressSortCell : UITableViewCell {
    
    var cellTag : Int = 0
    
    var callBack : callBack<Any> = {cellTag in}
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        self.selectionStyle = .none
        self.contentView.addSubview(self.selectButton)
        
        self.selectButton.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(0)
            make.right.equalToSuperview().offset(0)
            make.top.equalToSuperview().offset(6)
            make.bottom.equalToSuperview().offset(-6)
        }
        
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    lazy var selectButton : UIButton = {
        let view = UIButton(type: UIButton.ButtonType.custom)
        view.backgroundColor = UIColor(red: 0.95, green: 0.96, blue: 0.99, alpha: 1)
        view.layer.cornerRadius = 12
        view.clipsToBounds = true
        view.setTitleColor(UIColor(red: 0.2, green: 0.2, blue: 0.2, alpha: 1), for: .normal)
        view.addTarget(self, action: #selector(selectAction), for: .touchUpInside)
        view.layer.borderColor = UIColor(red: 0, green: 0.51, blue: 1, alpha: 1).cgColor
        return view
    }()
    
    
    @objc func selectAction(){
        callBack(self.cellTag)
    }
}
