//
//  ChargeViewCollectionCell.swift
//  PhoneManager
//
//  Created by edy on 2025/3/26.
//

import UIKit
import SnapKit

class ChargeViewCollectionCell:UICollectionViewCell {
    
    static let identifiers = "ChargeViewCollectionCellID"
    
    var flag : Int?
    
    var videoURL : URL?
    
    lazy var backImageView:UIImageView = {
        
        let sview:UIImageView = UIImageView()
        
        sview.contentMode = .scaleAspectFill
        sview.clipsToBounds = true
        
        return sview
    }()
    
    lazy var isFreeBtn:UIButton = {
        
        let sview:UIButton = UIButton()
        
        sview.setImage(UIImage(named: "ic_collect_com"), for: .normal)
        
        return sview
    }()
    
    override init(frame: CGRect) {
        
        super.init(frame: frame)
        
        setupUI()
        addSubview1()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setupUI() {
        
        backgroundColor = UIColor.random
        layer.cornerRadius = 12
        layer.masksToBounds = true
    }
    
    func addSubview1() {
        
        self.contentView.addSubview(backImageView)
        self.contentView.addSubview(isFreeBtn)
    }
    
    var model:ChargeDataModel! {
        
        didSet {
            
            DispatchQueue.main.async {[weak self] in
                
                guard let self else {return}
                
                self.backImageView.image = model.coverImage
                
                self.isFreeBtn.isHidden = model.isFree
                
                self.videoURL = model.url
            }
        }
    }
    
    override func layoutSubviews() {
        
        super.layoutSubviews()
        
        backImageView.snp.makeConstraints { make in
            
            make.center.width.height.equalToSuperview()
        }
        
        isFreeBtn.snp.makeConstraints { make in
            
            make.top.equalToSuperview().offset(12)
            make.right.equalToSuperview().offset(-12)
            make.width.height.equalTo(24)
        }
    }
}
