//
//  ChargeGuideNormalView.swift
//  PhoneManager
//
//  Created by edy on 2025/4/7.
//

import Foundation

class ChargeGuideNormalView : UIView{
    
    var orderFlag : Int = 1
    
    var callback :callBack<Any> = {text in}
    
    lazy var backView : UIImageView = {
        let view = UIImageView()
        view.image = UIImage(named: "image_76")
        return view
    }()
    
    lazy var tipTitleLabel:UILabel={
        let view = UILabel()
        view.text = "Animation Works with Apple Shortcuts"
        view.backgroundColor = .clear
        view.numberOfLines = 0
        view.textAlignment = .center
        view.font = UIFont.systemFont(ofSize: 18, weight: .bold)
        view.textColor = UIColor(red: 0.2, green: 0.2, blue: 0.2, alpha: 1)
        return view
    }()
    lazy var detailTipTitleLabel:UILabel={
        let view = UILabel()
        view.text = "Which helps to indicate the start of battery charging"
        view.numberOfLines = 0
        view.backgroundColor = .clear
        view.textAlignment = .center
        view.font = UIFont.systemFont(ofSize: 12, weight: .regular)
        view.textColor = UIColor(red: 0.4, green: 0.4, blue: 0.4, alpha: 1)
        return view
    }()
    
    lazy var guideView : UIImageView = {
        let view = UIImageView()
        return view
    }()
    
    
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        
        
        
        self.addSubview(self.backView)
        self.addSubview(self.tipTitleLabel)
        self.addSubview(self.detailTipTitleLabel)
        self.addSubview(self.guideView)
        
        self.backView.snp.makeConstraints { make in
            make.left.right.bottom.top.equalToSuperview()
        }
        self.tipTitleLabel.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(statusBarHeight + 44)
            make.left.equalToSuperview().offset(30)
            make.right.equalToSuperview().offset(-30)
            make.height.equalTo(50)
        }
        
        self.detailTipTitleLabel.snp.makeConstraints { make in
            make.top.equalTo(self.tipTitleLabel.snp.bottom).offset(4)
            make.height.equalTo(34)
            make.left.equalToSuperview().offset(30)
            make.right.equalToSuperview().offset(-30)
        }
        
        
        self.guideView.snp.makeConstraints { make in
            make.top.equalTo(self.detailTipTitleLabel.snp.bottom).offset(17)
            make.centerX.equalToSuperview()
            make.width.equalTo(316)
            make.height.equalTo(534)
        }
    }
    
    @objc func getNext(){
        callback("next")
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
}
