//
//  ChargeGuideController.swift
//  PhoneManager
//
//  Created by edy on 2025/4/7.
//

import Foundation

class ChargeGuideStartController : BaseViewController {
    
    var callback : callBack<Any> = {text in}
    
    lazy var backView : UIImageView = {
        let view = UIImageView()
        view.image = UIImage(named: "image_76")
        return view
    }()
    
    lazy var tipTitleLabel:UILabel={
        let view = UILabel()
        view.text = "Take a few minutes to set upthe feature"
        view.backgroundColor = .clear
        view.numberOfLines = 0
        view.textAlignment = .center
        view.font = UIFont.systemFont(ofSize: 18, weight: .bold)
        view.textColor = UIColor(red: 0.2, green: 0.2, blue: 0.2, alpha: 1)
        return view
    }()
    lazy var detailTipTitleLabel:UILabel={
        let view = UILabel()
        view.text = "Enjoy amazing animations every time you charge,just set it up once!"
        view.numberOfLines = 0
        view.backgroundColor = .clear
        view.textAlignment = .center
        view.font = UIFont.systemFont(ofSize: 12, weight: .regular)
        view.textColor = UIColor(red: 0.4, green: 0.4, blue: 0.4, alpha: 1)
        return view
    }()
    
    lazy var chargeView : UIImageView = {
        let view = UIImageView()
        view.image = UIImage(named: "Group_1171275119")
        return view
    }()
    
    lazy var startButton : UIButton = {
        let view = UIButton()
        view.setTitle("Get Started", for: .normal)
        view.backgroundColor = UIColor(red: 0.15, green: 0.42, blue: 1, alpha: 1)
        view.setTitleColor(.white, for: .normal)
        view.clipsToBounds = true
        view.layer.cornerRadius = 25
        view.addTarget(self, action: #selector(getStart), for: .touchUpInside)
        return view
    }()
    
    lazy var closeButton : UIButton = {
        let view = UIButton()
        view.backgroundColor = .clear
        view.setImage(UIImage(named: "ic_close_charging"), for: .normal)
        view.addTarget(self, action: #selector(closeCurrentPage), for: .touchUpInside)
        return view
    }()
    
    
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        self.view.addSubview(self.backView)
        self.view.addSubview(self.startButton)
        self.view.addSubview(self.closeButton)
        self.view.addSubview(self.tipTitleLabel)
        self.view.addSubview(self.detailTipTitleLabel)
        self.view.addSubview(self.chargeView)
        
        self.navigationController?.isNavigationBarHidden = true
        
        self.backView.snp.makeConstraints { make in
            make.left.right.bottom.top.equalToSuperview()
        }
        self.tipTitleLabel.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(statusBarHeight + 44)
            make.left.equalToSuperview().offset(30)
            make.right.equalToSuperview().offset(-30)
            make.height.equalTo(50)
        }
        self.detailTipTitleLabel.snp.makeConstraints { make in
            make.top.equalTo(self.tipTitleLabel.snp.bottom).offset(4)
            make.height.equalTo(34)
            make.left.equalToSuperview().offset(30)
            make.right.equalToSuperview().offset(-30)
        }
        
        self.startButton.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(15)
            make.right.equalToSuperview().offset(-15)
            make.bottom.equalToSuperview().offset(-safeHeight-37)
            make.height.equalTo(50)
        }
        
        self.chargeView.snp.makeConstraints { make in
            make.top.equalTo(self.detailTipTitleLabel.snp.bottom).offset(32)
            make.height.equalTo(453.5 * RScreenH())
            make.width.equalTo(345 * RScreenH())
            make.centerX.equalToSuperview()
            
        }
        self.closeButton.snp.makeConstraints { make in
            make.right.equalToSuperview().offset(-15)
            make.top.equalToSuperview().offset(statusBarHeight + 15)
            make.width.height.equalTo(28)
        }
        
    }
    
    @objc func closeCurrentPage(){
        self.navigationController?.dismiss(animated: true)
    }
    
    @objc func getStart() {
        let vc : ChargeGuideController = ChargeGuideController()
        self.navigationController?.pushViewController(vc, animated: true)
//        callback("getStart")
//        self.dismiss(animated: false)
    }
}
