//
//  AdvTipSelectView.swift
//  PhoneManager
//
//  Created by edy on 2025/4/21.
//

import Foundation
import SnapKit

enum TipSelectType {
    case selectTypeCompressVideo
    case selectTypeCompressPhoto
    case selectTypeSetAnimation
}

struct AdvTipSelectModel {
    let titleText: String
    let detailTitleText: String
    let deleteMoreText: String
    let deleteLessText:String
    
    init(titleText: String, detailTitleText: String, deleteMoreText: String, deleteLessText: String) {
        self.titleText = titleText
        self.detailTitleText = detailTitleText
        self.deleteMoreText = deleteMoreText
        self.deleteLessText = deleteLessText
    }
}


class AdvTipSelectView : UIViewController {
    
    var selectClickCallback : (Bool)->Void = {isSrue in }
    
    var selectType : TipSelectType?
    
    
    var tipSelectModel : AdvTipSelectModel?
    
    private var centerYConstraint: Constraint?

    
    lazy var tipView : UIView = {
        let view = UIView()
        view.backgroundColor = .white
        view.clipsToBounds = true
        view.layer.cornerRadius = 12
        return view
    }()
    
    lazy var closeButton : UIButton = {
        let view = UIButton(type: .custom)
        view.setImage(UIImage(named: "icon_close_pop_purple"), for: .normal)
        view.addTarget(self, action: #selector(closeButtonAction), for: .touchUpInside)
        return view
    }()
    
    lazy var logoView : UIImageView = {
        let view = UIImageView()
        view.image = UIImage(named: "ic_gift_ad")
        return view
    }()
    
    lazy var tipTitle : UILabel = {
        let view = UILabel()
        view.numberOfLines = 0
        view.font = UIFont.systemFont(ofSize: 20, weight: .bold)
        view.textColor = UIColor(red: 0.1, green: 0.1, blue: 0.1, alpha: 1)
        view.textAlignment = .center
        return view
    }()
    
    lazy var tipDetailTitle : UILabel = {
        let view = UILabel()
        view.numberOfLines = 0
        view.font = UIFont.systemFont(ofSize: 14, weight: .regular)
        view.textColor = UIColor(red: 0.4, green: 0.4, blue: 0.4, alpha: 1)
        view.textAlignment = .center
        return view
    }()
    
    
    
    lazy var firstButton : UIButton = {
        let view = UIButton(type: .custom)
        view.backgroundColor = UIColor(red: 0, green: 0.51, blue: 1, alpha: 1)
        view.setTitleColor(.white, for: .normal)
        view.clipsToBounds = true
        view.layer.cornerRadius = 24
        view.titleLabel?.font = UIFont.systemFont(ofSize: 16, weight: .bold)
        view.setImage(UIImage(named: "ic_ad_pop"), for: .normal)
        // 设置间距为 8
        let spacing: CGFloat = 8
        // 获取图片和文字的大小
        let imageSize = view.imageView?.image?.size ?? .zero
        let titleSize = view.titleLabel?.intrinsicContentSize ?? .zero
        // 计算 imageEdgeInsets 和 titleEdgeInsets
        view.imageEdgeInsets = UIEdgeInsets(top: 0, left: -spacing / 2, bottom: 0, right: spacing / 2)
        view.titleEdgeInsets = UIEdgeInsets(top: 0, left: spacing / 2, bottom: 0, right: -spacing / 2)
        view.addTarget(self, action: #selector(buttonSureSelectAction), for: .touchUpInside)
        return view
    }()
    
    
    lazy var secondButton : UIButton = {
        let view = UIButton(type: .custom)
        view.backgroundColor = .clear
        view.setTitleColor(UIColor(red: 0.4, green: 0.4, blue: 0.4, alpha: 1), for: .normal)
        view.clipsToBounds = true
        view.layer.cornerRadius = 24
        view.titleLabel?.font = UIFont.systemFont(ofSize: 16, weight: .bold)
        view.addTarget(self, action: #selector(buttonCancelSelectAction), for: .touchUpInside)
        return view
    }()
    
    
    override func viewDidLoad() {
        super.viewDidLoad()
        self.view.backgroundColor = .clear
        setup()
    }
    
    func setup() -> Void {
        self.view.addSubview(self.tipView)
        self.tipView.addSubview(self.closeButton)
        self.tipView.addSubview(self.logoView)
        self.tipView.addSubview(self.tipTitle)
        self.tipView.addSubview(self.tipDetailTitle)
        
        self.tipView.addSubview(self.firstButton)
        self.tipView.addSubview(self.secondButton)
        
        
        
        
        self.tipView.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.width.equalTo(345)
            make.height.equalTo(432)
            make.centerY.equalToSuperview()
//            centerYConstraint = make.centerY.equalToSuperview().offset(self.height + 220).constraint
        }
        
        self.closeButton.snp.makeConstraints { make in
            make.top.equalTo(20)
            make.right.equalTo(-20)
            make.width.height.equalTo(28)
        }
        
        self.logoView.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.top.equalTo(52)
            make.width.equalTo(197)
            make.height.equalTo(126)
        }
        self.tipTitle.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.width.equalTo(229)
            make.height.equalTo(56)
            make.top.equalTo(self.logoView.snp.bottom).offset(16)
        }
        
        self.tipDetailTitle.snp.makeConstraints { make in
            make.top.equalTo(self.tipTitle.snp.bottom).offset(8)
            make.width.equalTo(305)
            make.height.equalTo(40)
            make.centerX.equalToSuperview()
        }
        self.firstButton.snp.makeConstraints { make in
            make.top.equalTo(self.tipDetailTitle.snp.bottom).offset(16)
            make.width.equalTo(305)
            make.height.equalTo(48)
            make.centerX.equalToSuperview()
        }
        self.secondButton.snp.makeConstraints { make in
            make.top.equalTo(self.firstButton.snp.bottom).offset(4)
            make.width.equalTo(305)
            make.height.equalTo(48)
            make.centerX.equalToSuperview()
        }
        
        // 先显示背景，然后延迟显示弹框
//        DispatchQueue.main.asyncAfter(deadline: .now() + 0.01) {
//            UIView.animate(withDuration: 0.4) {
//                // 更新约束
//                self.centerYConstraint?.update(offset: 0)
//                self.layoutIfNeeded()
//            }
//        }
    }
    
//    override func removeFromSuperview() {
//        UIView.animate(withDuration: AniDuration) {
//            // 更新约束
////            self.backgroundColor = .clear
////            self.centerYConstraint?.update(offset: self.height + 220)
////            self.layoutIfNeeded()
//            var frame = self.bounds
//            frame.origin.y = frame.height
//            self.frame = frame
//        }completion: { _ in
//            super.removeFromSuperview()
//        }
//    }
    
}

extension AdvTipSelectView{
    
    
    func getOtherInfoByType() {
        switch self.selectType {
        case .selectTypeCompressVideo:
            self.tipSelectModel =  AdvTipSelectModel.init(
                titleText: "Watch a rewarded ad to compress your video",
                detailTitleText: "You need to watch an ad to compress your video with the free version.",
                deleteMoreText: "Compress", deleteLessText: "Cancel")
        case .selectTypeCompressPhoto:
            self.tipSelectModel =  AdvTipSelectModel.init(
                titleText: "Watch a rewarded ad to compress your photo",
                detailTitleText: "You need to watch an ad to compress your photo with the free version.",
                deleteMoreText: "Compress", deleteLessText: "Cancel")
        case .selectTypeSetAnimation:
            self.tipSelectModel =  AdvTipSelectModel.init(
                titleText: "Watch a rewarded ad to set Pro Animations",
                detailTitleText: "You need to watch an ad to set amazing animations that are unlimited for pro users.",
                deleteMoreText: "Set Animation", deleteLessText: "Cancel")
        case .none:
            self.tipSelectModel =  AdvTipSelectModel.init(
                titleText: "",
                detailTitleText: "",
                deleteMoreText: "", deleteLessText: "")
        }
        self.tipTitle.text = self.tipSelectModel?.titleText
        self.tipDetailTitle.text = self.tipSelectModel?.detailTitleText
        self.firstButton.setTitle(self.tipSelectModel?.deleteMoreText, for: .normal)
        self.secondButton.setTitle(self.tipSelectModel?.deleteLessText, for: .normal)
    }
    @objc func closeButtonAction(){
        self.selectClickCallback(false)
//        self.removeFromSuperview()
    }
    @objc func buttonSureSelectAction(){
        self.selectClickCallback(true)
//        self.removeFromSuperview()
    }
    @objc func buttonCancelSelectAction(){
        self.selectClickCallback(false)
//        self.removeFromSuperview()
    }
    
}
