import Foundation

// 顶层响应模型
struct ResponseModel<T: Codable>: Codable {
    let status: Int
    let msg: String
    let sign: String
    let result: ResultModel<T>
    let enc: String?
    let security: String
}

// 结果模型
struct ResultModel<T: Codable>: Codable {
    let data: String?
    let extras: String?
    
    // 自定义解码方法，将 data 字符串解析为泛型模型
    var parsedData: T? {
        guard let jsonString = data,
              let jsonData = jsonString.data(using: .utf8) else {
            return nil
        }
        return try? JSONDecoder().decode(T.self, from: jsonData)
    }
}
