//
//  ActorManager.swift
//  CleanPhoto
//
//  Created by edy on 2025/5/9.
//

import Foundation
import UIKit


// 图片状态管理 actor
actor PhotoSimilarStateManager {
    private var timeGroups: [TimeGroupModel] = []
    private var similarGroups: [SimilarGroupModel] = []
    private var pendingSimilarGroups: [SimilarGroupModel] = []
    private var processedGroupCount: Int = 0
    private var assetsImageCache: [String: UIImage] = [:]
    private var hashCache: [String: String] = [:]
    
    func appendTimeGroup(_ group: TimeGroupModel) {
        timeGroups.append(group)
    }
    
    func appendSimilarGroup(_ group: SimilarGroupModel) {
        pendingSimilarGroups.append(group)
        processedGroupCount += 1
    }
    
    func getAllTimeGroups() -> [TimeGroupModel] {
        return timeGroups
    }
    
    func getpendingSimilarGroups() -> [SimilarGroupModel] {
        return pendingSimilarGroups
    }
    
    func getAllSimilarGroups() -> [SimilarGroupModel] {
        return similarGroups
    }
    
    func getCachedImage(for identifier: String) -> UIImage? {
        return assetsImageCache[identifier]
    }
    
    func setCachedImage(_ image: UIImage, for identifier: String) {
        assetsImageCache[identifier] = image
    }
    
    func shouldSavePendingGroups() -> Bool {
        return processedGroupCount >= 10
    }
    
    func getCachedHash(for identifier: String) async -> String? {
        return hashCache[identifier]
    }
    
    func setCachedHash(_ hash: String, for identifier: String) async {
        hashCache[identifier] = hash
    }
    
    func savePendingGroups() {
        similarGroups.append(contentsOf: pendingSimilarGroups)
        pendingSimilarGroups.removeAll()
        processedGroupCount = 0
    }
    
    func loadStoredData(timeGroups: [TimeGroupModel], similarGroups: [SimilarGroupModel]) {
        self.timeGroups = timeGroups
        self.similarGroups = similarGroups
    }
    
    func deleteData(for idsToRemove:[String]){
        let updateGroups = self.similarGroups.removingGroupsWithEmptyAssetsWithDetails(afterRemovingIDs: idsToRemove)
        self.similarGroups = updateGroups.updatedGroups
    }
}

actor PhotoDuplicateStateManager {
    private var duplicateGroups: [SimilarGroupModel] = []
    private var pendingDuplicateGroups: [SimilarGroupModel] = []
    
    // 缓存
    private var imageCache: [String: UIImage] = [:]
    private var hashCache: [String: String] = [:]
    
    // MARK: - 公共方法
    
    func loadStoredData(duplicateGroups: [SimilarGroupModel]) {
        self.duplicateGroups = duplicateGroups
    }
    
    func getAllDuplicateGroups() -> [SimilarGroupModel] {
        return duplicateGroups
    }
    
    func appendDuplicateGroup(_ group: SimilarGroupModel) {
        pendingDuplicateGroups.append(group)
    }
    
    func shouldSavePendingGroups() -> Bool {
        return pendingDuplicateGroups.count >= 5
    }
    
    func savePendingGroups() {
        duplicateGroups.append(contentsOf: pendingDuplicateGroups)
        pendingDuplicateGroups.removeAll()
    }
    
    func getPendingDuplicateGroups() -> [SimilarGroupModel] {
        return pendingDuplicateGroups
    }
    
    func removeGroup(){
        self.duplicateGroups.removeAll()
    }
    
    // MARK: - 缓存相关
    
    func getCachedImage(for identifier: String) -> UIImage? {
        return imageCache[identifier]
    }
    
    func setCachedImage(_ image: UIImage, for identifier: String) {
        imageCache[identifier] = image
    }
    
    func getCachedHash(for identifier: String) -> String? {
        return hashCache[identifier]
    }
    
    func setCachedHash(_ hash: String, for identifier: String) {
        hashCache[identifier] = hash
    }
    
    func deleteData(for idsToRemove:[String]){
        let updateGroups = self.duplicateGroups.removingGroupsWithEmptyAssetsWithDetails(afterRemovingIDs: idsToRemove)
        self.duplicateGroups = updateGroups.updatedGroups
    }
}

