//
//  BaseNavView.swift
//  PhoneManager
//
//  Created by edy on 2025/3/21.
//

import UIKit

class BaseNavView:UIView {
    
    var callBack: callBack<Any> = {text in }
    
    lazy var model:BaseNavViewModel =  {
       
        let model :BaseNavViewModel = BaseNavViewModel()
        
        model.callBack = {[weak self] (text) in
            
            self?.setupUI()
        }
        
        return model
    }()
    
    lazy var lineView:UIView = {
        
        let sview:UIView = UIView()
        sview.width = width
        sview.height = 0.5
        sview.y = height - 0.5
        sview.x = 0
        
        sview.backgroundColor = UIColor.colorWithHex(hexStr: whiteColor, alpha: 0.08)
        
        return sview
    }()
    
    lazy var titleLabel:UILabel = {
       
        let titleLabel:UILabel = UILabel()
        titleLabel.font = UIFont.systemFont(ofSize: 18.RW(), weight: .medium)
        titleLabel.textColor = .black
        titleLabel.textAlignment = .center
        return titleLabel
    }()
    
    lazy var backBtn:EnlargeBtn = {
        
        let sview:EnlargeBtn = EnlargeBtn(frame: CGRect(x: 0, y: 0, width: iconWH, height: iconWH))
        sview.setBackgroundImage(UIImage(named: "nav_back"), for: .normal)
        sview.height = iconWH
        sview.width = iconWH
        sview.x = marginLR
        sview.centerY = (height - statusBarHeight) / 2 + statusBarHeight
        sview.addTarget(self, action: #selector(backBtnClick(btn:)), for: .touchUpInside)
        
        return sview
    }()
    
    override init(frame: CGRect) {
        
        super.init(frame: CGRect(x: 0, y: 0, width: ScreenW, height: navHeight))
        setupUI()
        addView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setupUI() {
        
        backgroundColor = UIColor.colorWithHex(hexStr: model.backgroundColor)
        
        titleLabel.text = model.title
        titleLabel.sizeToFit()
        titleLabel.width = width - 2 * marginLR - (iconWH + 8.RW()) * 2
        titleLabel.centerX = width / 2
        titleLabel.centerY = (height - statusBarHeight) / 2 + statusBarHeight
        
        titleLabel.isHidden = model.titleHidden
        
        if model.titleLabelX != 0{
            
            titleLabel.x = backBtn.x + backBtn.width + model.titleLabelX
            titleLabel.width = width - titleLabel.x - 30.RW() - 28.RW()
        }
        
        backBtn.isHidden = !model.isBackBtnShow
    }
    
    func addView() {
        addSubview(lineView)
        addSubview(titleLabel)
        addSubview(backBtn)
    }
    
    @objc func backBtnClick(btn:UIButton) {
        
         callBack("back")
    }
}

class BaseNavViewModel {
    
    var callBack: callBack<Any> = {text in }
    
    
    var title:String = "" {
        
        didSet {
            callBack("title")
        }
    }
    
    var backgroundColor:String = navBack {
        
        didSet {
            
            callBack("backgroundColor")
        }
    }
    
    var isBackBtnShow:Bool = false {
        didSet {
            
            callBack("isBackBtnShow")
        }
    }
    
    var titleLabelX:CGFloat = 0 {
        
        didSet {
            
            callBack("titleLabelX")
        }
    }
    
    var titleHidden:Bool = false {
        
        didSet {
            
            callBack("titleHidden")
        }
    }
    
}



