//
//  LockSreen.swift
//  LockSreen
//
//  Created by edy on 2025/5/19.
//

import WidgetKit
import SwiftUI

struct lockEmpty:View {
    var body: some View {
        ZStack(content: { })
    }
}

// 正方形
struct LockSreenSquareView : View {
    var entry:LockSreenProvider.Entry
    var type:lockSreenType = lockSreenType()
    var body: some View {
        GeometryReader(content: { geometry in
            let width = min(geometry.size.width, geometry.size.height)
            ZStack {
                let img = (type.isStorage ? "pm_storage_widgets_blue" : "pm_battery_widgets_blue")
                let degree = (type.isStorage ? Double(entry.widgetUseSpace)/Double(entry.widgetAllSpace) * 360.0 : Double(entry.widgetBattery))
                Image(img, bundle: nil).aspectRatio(contentMode: .fill)
                lockArcShape(startAngle: .degrees(-90), endAngle:.degrees(degree-90)).stroke(style: StrokeStyle(lineWidth: 4, lineCap: .round))
            }.frame(width: width, height: width)
        })
    }
}

// 长方形
struct LockSreenRectView : View {
    var entry:LockSreenProvider.Entry
    var type:lockSreenType = lockSreenType()
    var body: some View {
        let use = (Double(entry.widgetUseSpace)/Double(entry.widgetAllSpace))
        HStack(content: {
            VStack(spacing: 10, content: {
                let name = type.isStorage ? "Storage" : "Battery"
                let use = type.isStorage ? String("\(Int(use*100))%") : String("\(entry.widgetBattery)%")
                let descp = type.isStorage ? String(" \(entry.widgetUseSpace)/\(entry.widgetAllSpace)GB") : entry.isCharging ? "Charging" : "No action"
                VStack(spacing: 2, content: {
                    Text(name).font(.system(size: 12)).frame(maxWidth: .infinity,alignment:.leading)
                    Text(use).frame(maxWidth: .infinity, alignment: .leading).font(.system(size: 16,weight: .bold))
                })
                Text(descp).font(.system(size: 10)).frame(maxWidth: .infinity, alignment: .leading)
            })
            ZStack {
                let img = (type.isStorage ? "pm_storage_widgets_blue" : "pm_battery_widgets_blue")
                let degree = (type.isStorage ? Double(entry.widgetUseSpace)/Double(entry.widgetAllSpace) * 360 : Double(entry.widgetBattery))
                Image(img, bundle: nil).aspectRatio(contentMode: .fill)
                lockArcShape(startAngle: .degrees(-90), endAngle: .degrees( degree-90)).stroke(style: StrokeStyle(lineWidth: 4, lineCap: .round))
            }
        })
    }
}


// 二者长方形
struct LockSreenBothView : View {
    var entry:LockSreenProvider.Entry
    var body: some View {
        let use = (Double(entry.widgetUseSpace)/Double(entry.widgetAllSpace))
        VStack(content: {
            HStack(spacing: 5, content: {
                Image("pm_battery_widgets_small")
                Text("Battery").frame(maxWidth: .infinity, alignment: .leading).font(.system(size: 12,weight: .regular))
                Text(String("\(entry.widgetBattery)%")).font(.system(size: 12,weight: .medium))
            })
            HStack(spacing: 3, content: {
                Image("pm_storage_widgets_small")
                Text("Storage").frame(maxWidth: .infinity, alignment: .leading).font(.system(size: 12,weight: .regular))
                Text(String("\(Int(use*100))%")).font(.system(size: 12,weight: .medium))
            })
        })
        .padding(EdgeInsets(top: 0, leading: 0, bottom: 0, trailing: 0))
    }
}


struct LockSreenEntryView : View {
    var type:lockSreenType = lockSreenType()
    var entry: LockSreenProvider.Entry
    @Environment(\.widgetFamily) var family
    var body: some View {
        switch family {
        case .accessoryCircular:
            LockSreenSquareView(entry: entry ,type: type)
        case .accessoryRectangular:
            LockSreenRectView(entry: entry ,type: type)
        default:
            lockEmpty()
        }
    }
}

// 圆孤
struct lockArcShape: Shape {
    var startAngle: Angle
    var endAngle: Angle
    func path(in rect: CGRect) -> Path {
        var path = Path()
        let center = CGPoint(x: rect.midX, y: rect.midY)
        let radius = min(rect.width, rect.height) / 2.0 - 2
        path.addArc(
            center: center,
            radius: radius,
            startAngle: startAngle,
            endAngle: endAngle,
            clockwise: false
        )
        return path
    }
}

