//
//  widgetBundle.swift
//  widget
//
//  Created by edy on 2025/4/3.
//

import WidgetKit
import SwiftUI

@main
struct widgetBundle: WidgetBundle {
    var body: some Widget {
        BatteryWidget()
        BatteryWidget1()
        BatteryWidget2()
    }
}

extension Color {
    init(_ hex:String = "FFFFFF") {
        let scanner = Scanner(string: hex)
        scanner.currentIndex = hex.startIndex
        var rgb:UInt64 = 0
        scanner.scanHexInt64(&rgb)
        let r = Double( (rgb & 0xff0000) >> 16) / 255.0
        let g = Double( (rgb & 0xff00) >> 8) / 255.0
        let b = Double( (rgb & 0xff)) / 255.0
        self.init(red: r, green: g, blue: b)
    }
    
}
