//
//  UIFont+Ex.swift
//  PhoneManager
//
//  Created by edy on 2025/4/29.
//

import Foundation
import UIKit

extension UIFont {
    /// 返回按比例缩放后的字体
    /// - Parameter size: 原始字体大小
    /// - Returns: 缩放后的字体
    static func scaledSystemFont(ofSize size: CGFloat,weight:UIFont.Weight = .regular) -> UIFont {
        let scale: CGFloat = RW // 这里可以根据需要调整缩放系数
        return .systemFont(ofSize: size*scale, weight: weight)
    }

}
