//
//  yQzSnStarView.swift
//  PhoneManager
//
//  Created by edy on 2025/4/9.
//

import UIKit

class yQzSnStarView: UIView {

    var maxStar = 5 {
        didSet {
            reloadView()
        }
    }
    
    var spacing:CGFloat = 5 {
        didSet {
            starStack.spacing = self.spacing
        }
    }
    var axis:NSLayoutConstraint.Axis = .vertical {
        didSet {
            starStack.axis = axis
        }
    }
    
    var currentStar = 5 {
        didSet {
            reloadView()
        }
    }
    
    private func reloadView() -> Void {
        for v in starStack.arrangedSubviews {
            starStack.removeArrangedSubview(v)
        }
        for i in 0..<maxStar {
            let iconName = i < currentStar ? "star_01" : "star_02"
            let icon = UIImageView(image: UIImage(named: iconName))
            icon.contentMode = .scaleToFill
            starStack.addArrangedSubview(icon)
            icon.snp.makeConstraints { make in
                make.width.equalTo(icon.snp.height)
            }
        }
    }

    private func setupUI() -> Void {
        starStack.snp.makeConstraints { make in
            make.left.top.bottom.right.equalToSuperview()
        }
    }
    
    private lazy var starStack: UIStackView = {
        let star = UIStackView()
        star.axis = .horizontal
        star.spacing = 5
        star.alignment = .center
        star.distribution = .fillEqually
        addSubview(star)
        return star
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }

}
