//
//  PMAlertView.swift
//  PhoneManager
//
//  Created by edy on 2025/4/8.
//

import UIKit

class PMAlertView: UIViewController {

    private var pm_msg:String?
    
    override func viewDidLoad() {
        super.viewDidLoad()
    }

    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        setUI()
    }
    
    private func setUI() -> Void {
        pm_ActivityIndicator.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.top.equalToSuperview().offset(13)
            make.size.equalTo(CGSize(width: 24, height: 24))
        }
        massage.snp.makeConstraints { make in
            make.top.equalTo(pm_ActivityIndicator.snp.bottom).offset(15)
            make.width.lessThanOrEqualTo(140)
            make.width.greaterThanOrEqualTo(50)
            make.right.left.equalToSuperview()
            make.bottom.equalTo(content.snp.bottom).offset(-5)
        }
        content.snp.makeConstraints { make in
            make.centerX.centerY.equalToSuperview()
        }
    }
    
    func show() -> Void {
        DispatchQueue.main.async {
            Print("显示弹窗")
            guard let rt = UIViewController.topMostViewController()
            else { return }
            if let vc = rt as? PMAlertView {
                return
            }
            self.modalPresentationStyle = .overFullScreen
            self.modalTransitionStyle = .crossDissolve
            rt.present(self, animated: true)
        }
    }
    
    func dismiss() -> Void {
        DispatchQueue.main.async {
            Print("关闭弹窗")
            self.dismiss(animated: true)
        }
    }

    convenience init( _ message:String?) {
        self.init()
        self.pm_msg = message
    }
    
    private lazy var pm_ActivityIndicator: UIActivityIndicatorView = {
        let pmact = UIActivityIndicatorView()
        pmact.style = .medium
        pmact.startAnimating()
        content.addSubview(pmact)
        pmact.color = .black
        pmact.transform = CGAffineTransformMakeScale(1.3, 1.3)
        return pmact
    }()
    
    private lazy var content: UIView = {
        let content = UIView()
        content.backgroundColor = .clear
        content.layer.cornerRadius = 14;
        view.addSubview(content)
        return content
    }()
    
    private lazy var massage: UILabel = {
        let msg = UILabel()
        msg.textAlignment = .center
        msg.numberOfLines = 0
        msg.font = UIFont.systemFont(ofSize: 15)
        msg.textColor = .colorWithHex(hexStr: "#333333")
        content.addSubview(msg)
        return msg
    }()
}
