//
//  Common.swift
//  PhoneManager
//
//  Created by zxhy on 2025/3/19.
//

import UIKit

//间距

let ScreenW:CGFloat = UIScreen.main.bounds.size.width

let ScreenH:CGFloat = UIScreen.main.bounds.size.height

let RW:CGFloat = RScreenW()

let RH:CGFloat = RScreenH()

let tabHeight:CGFloat = 49

var safeHeight:CGFloat = 0

var statusBarHeight:CGFloat = 0

var navHeight:CGFloat = 44

let navDefaultHeight:CGFloat = 44

var navCenterY:CGFloat = 0

let iconWH:CGFloat = 28

let marginLR:CGFloat = 15

let AniDuration:CGFloat = 0.4


//颜色
let launchColor:String = "#7F33FF"

let dBackColor:String = "#ffffff"

let whiteColor:String = "#ffffff"

let mColor:String = "#0082FF"

let navBack:String = "#ffffff"

let blackColor:String = "#000000"

let black3Color:String = "#333333"

let black6Color:String = "#666666"


func RScreenW() -> CGFloat {
    
    return ScreenW / 375
}

func RScreenH() -> CGFloat {
    
    let radio:CGFloat = ScreenH / 812
    
    return radio
}

let kSafeAreaInsets:UIEdgeInsets = kcWindow.safeAreaInsets


let kcWindow:UIWindow = {
    if #available(iOS 13, *) {
        return UIApplication.shared.connectedScenes
            .compactMap { $0 as? UIWindowScene }
            .first?.windows.first ?? UIWindow()
    } else {
        return UIApplication.shared.keyWindow ?? UIWindow()
    }
}()


public func Alert( _ title:String? , _ message:String) -> Void {
    let alert = UIAlertController(title: title, message: message, preferredStyle: .alert)
    alert.addAction(UIAlertAction(title: "OK", style: .cancel))
    cWindow?.rootViewController?.present(alert, animated: true)
}


func GETCURRENTNAV() -> UINavigationController? {
    let k = UIApplication.shared.windows.filter({$0.isKeyWindow}).first
    let pre = k?.rootViewController?.presentedViewController
    let rt = k?.rootViewController
    return (pre as? UINavigationController) ?? ((rt as? UITabBarController)?.selectedViewController as? UINavigationController) ?? (rt as? UINavigationController)
}


func GETCURRENTVC() -> UIViewController? {
    let k = UIApplication.shared.windows.filter({$0.isKeyWindow}).first
    let pre = k?.rootViewController?.presentedViewController
    let rt = k?.rootViewController
    return pre ?? ((rt as? UITabBarController)?.selectedViewController) ?? rt
}

func GETCURRENTVCNAME() -> String {
    guard let currentVC = GETCURRENTVC() else { return "" }
    let className = NSStringFromClass(type(of: currentVC))
    // 如果需要去掉模块名，可以用下面这行
    // return className.components(separatedBy: ".").last ?? className
    return className
}

