//
//  UserActivityManager.swift
//  PhoneManager
//
//  Created by edy on 2025/3/26.
//

import AppIntents


@available(iOS 16, *)
struct LaunchAppIntent: AppIntent {
    
    static var title: LocalizedStringResource = "打开应用"
    static var description: IntentDescription = IntentDescription("打开并启动应用")
    
    // 执行操作
    func perform() async throws -> some IntentResult {
        // 这里可以添加启动应用后的具体操作
        return .result()
    }
}

@available(iOS 16, *)
struct AppShortcuts: AppShortcutsProvider {
    static var appShortcuts: [AppShortcut] {
        AppShortcut(
            intent: LaunchAppIntent(),
            phrases: [
                "打开 \(.applicationName)",
                "启动 \(.applicationName)",
                "运行 \(.applicationName)"
            ],
            systemImageName: "app.fill"
        )
    }
}

