//
//  EmailEmptyView.swift
//  PhoneManager
//
//  Created by edy on 2025/5/9.
//

import UIKit

class EmailEmptyView: UIView {
    
    var callblock:(()->Void) = {}
    
    @objc private func loginAction() -> Void {
        callblock()
    }
    
    //FIXME: 差个链接
    @objc private func PrivacyPolicy(_ ges:UIGestureRecognizer) -> Void {
        let touch = ges.location(in: descpLabel)
        let content = CGRectMake((descpLabel.width - 100) / 2.0, descpLabel.height - 25, 100, 25)
        if CGRectContainsPoint(content, touch) {
            let vc:PrivacyPolicyWebViewController = PrivacyPolicyWebViewController()
            UIViewController.topMostViewController()?.navigationController?.pushViewController(vc, animated: true)
//            let web = BaseWebViewController()
//            web.LoadWithUrl(url: "")
//            UIViewController.topMostViewController()?.navigationController?.pushViewController(web, animated: true)
        }
    }
    
    private func setup() -> Void {
        emptystack.addArrangedSubview(icon)
        emptystack.addArrangedSubview(descpLabel)
        emptystack.addArrangedSubview(signEmail)
        emptystack.snp.makeConstraints { make in
            make.left.right.equalToSuperview().inset(30)
            make.centerY.equalToSuperview().offset(-30.RH())
        }
        signEmail.snp.makeConstraints { make in
            make.height.equalTo(50)
            make.width.equalToSuperview()
        }
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setup()
    }

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    private lazy var emptystack: UIStackView = {
        let stack = UIStackView()
        stack.axis = .vertical
        stack.spacing = 50
        stack.alignment = .center
        stack.distribution = .equalSpacing
        addSubview(stack)
        return stack
    }()
    
    private lazy var icon: UIImageView = {
        let icon = UIImageView(image: UIImage(named: "img_email"))
        icon.contentMode = .scaleAspectFill
        return icon
    }()
    
    private lazy var descpLabel: UILabel = {
        let l = UILabel()
        l.textAlignment = .center
        l.numberOfLines = 0
        l.textColor = UIColor(hex: "#666666")
        l.font = UIFont.systemFont(ofSize: 14)
        let attrString = NSMutableAttributedString(string: "Cleans the mails in the categories you choose,according to the filters you apply. Your Gmail account and password is not stored in our app and Gmail secures the process.\nPrivacy Policy")
        let strSubAttr2: [NSMutableAttributedString.Key: Any] = [.foregroundColor: UIColor(hex: "#0082FF") ?? .clear, .underlineStyle: NSUnderlineStyle.single.rawValue, .underlineColor: UIColor(hex: "#0082FF") ?? .clear]
        attrString.addAttributes(strSubAttr2, range: NSRange(location: 170, length: 14))
        l.attributedText = attrString
        l.isUserInteractionEnabled = true
        let tap = UITapGestureRecognizer(target: self, action: #selector(PrivacyPolicy(_:)))
        l.addGestureRecognizer(tap)
        return l
    }()
    
    private lazy var signEmail: UIButton = {
        let emailLogin = UIButton(type: .custom)
        emailLogin.setImage(UIImage(named: "emailSmall"), for: .normal)
        emailLogin.setTitle("Sign in with Google", for: .normal)
        emailLogin.setTitleColor(.white, for: .normal)
        emailLogin.titleLabel?.font = UIFont.systemFont(ofSize: 16)
        emailLogin.backgroundColor = UIColor(hex: "#0082FF")
        emailLogin.layer.cornerRadius = 50/2.0
        emailLogin.addTarget(self, action: #selector(loginAction), for: .touchUpInside)
        emailLogin.titleEdgeInsets = UIEdgeInsets(top: 0, left: 10, bottom: 0, right: 0)
        return emailLogin
    }()
    
}
