//
//  EmailContentBottonAction.swift
//  PhoneManager
//
//  Created by edy on 2025/5/9.
//

import UIKit

class EmailContentBottonAction: UIView {

    enum ActionState:Int {
    case EmailGroup = 0
    case EmailList = 1
    }
    
    var callblock = {}
    var state:ActionState = .EmailGroup
    
    var numberMails:Int = 0 {
        didSet {
            DelEmailBtn.setTitle(btnTitle(), for: .normal)
            DelEmailBtn.isEnabled = numberMails > 0
        }
    }
    
    @objc private func delMails() -> Void {
        callblock()
    }
    
    private func setup() -> Void {
        DelEmailBtn.snp.makeConstraints { make in
            make.left.right.equalToSuperview().inset(marginLR)
            make.height.equalTo(46)
            make.top.equalToSuperview().offset(12)
        }
        if state == .EmailGroup {
            DelEmailBtn.setBackgroundImage(UIImage.Clear(UIColor(hex: "#7FC0FF") ?? .clear), for: .disabled)
            DelEmailBtn.setBackgroundImage(UIImage.Clear(UIColor(hex: "#0082FF") ?? .clear), for: .normal)
        }else{
            DelEmailBtn.setBackgroundImage(UIImage.Clear(UIColor(hex: "#F5A2A2") ?? .clear), for: .disabled)
            DelEmailBtn.setBackgroundImage(UIImage.Clear(UIColor(hex: "#EB4545") ?? .clear), for: .normal)
        }
    }
    
    convenience init(state:ActionState) {
        self.init(frame: CGRect())
        self.state = state
        setup()
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
    }
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }

    private lazy var DelEmailBtn: UIButton = {
        let emailLogin = UIButton(type: .custom)
        emailLogin.setImage(UIImage(named: "ic_delete_duplicates"), for: .normal)
        emailLogin.setTitle(btnTitle(), for: .normal)
        emailLogin.setTitleColor(.white, for: .normal)
        emailLogin.titleLabel?.font = UIFont.boldSystemFont(ofSize: 16)
        emailLogin.layer.cornerRadius = 46/2.0
        emailLogin.clipsToBounds = true
        emailLogin.addTarget(self, action: #selector(delMails), for: .touchUpInside)
        emailLogin.titleEdgeInsets = UIEdgeInsets(top: 0, left: 10, bottom: 0, right: 0)
        emailLogin.setBackgroundImage(UIImage.Clear(UIColor(hex: "#7FC0FF") ?? .clear), for: .disabled)
        emailLogin.setBackgroundImage(UIImage.Clear(UIColor(hex: "#0082FF") ?? .clear), for: .normal)
        addSubview(emailLogin)
        return emailLogin
    }()
    
    private func btnTitle() -> String {
        return "Delete \(numberMails) Mails"
    }
}
