//
//  EmailLoginController.swift
//  PhoneManager
//
//  Created by edy on 2025/5/9.
//

import UIKit

class EmailLoginController: BaseViewController {

    enum fromState {
    case home
    case set
    }
    
    var callblock:(()->Void)?
    
    var state:fromState = .home
    
    override func viewDidLoad() {
        super.viewDidLoad()
        setup()
    }

    func setup() -> Void {
        titleLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(marginLR)
            make.top.equalTo(titleView.snp.bottom).offset(20)
        }
        EmptyView.snp.makeConstraints { make in
            make.left.right.bottom.equalToSuperview()
            make.top.equalTo(titleLabel.snp.bottom)
        }
    }
    
    private lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.text = "Email Cleaner"
        label.font = UIFont.systemFont(ofSize: 20, weight: .bold)
        label.textColor = .black
        label.textAlignment = .left
        view.addSubview(label)
        return label
    }()
    
    private lazy var EmptyView: EmailEmptyView = {
        let empty = EmailEmptyView()
        view.addSubview(empty)
        empty.callblock = {[weak self] in
            guard let self = self else { return }
            PMEmailManager.shareManager.initOAuth(self) { success in
                if success {
                    if self.state == .home {
                        let gourp = EmailCleanController()
                        var navigation = self.navigationController?.viewControllers
                        if self.callblock != nil {
                            self.callblock!()
                        }
                        if navigation?.count ?? 0 > 1 {
                            navigation![navigation!.count-1] = gourp
                            self.navigationController?.setViewControllers(navigation ?? [], animated: true)
                        }
                        
                    }else{
                        self.navigationController?.popViewController(animated: true)
                    }
                }
            }
        }
        return empty
    }()
    
}
