//
//  EmailKeywordController.swift
//  PhoneManager
//
//  Created by edy on 2025/5/12.
//

import UIKit

class EmailKeywordController: UIViewController {

    override func viewDidLoad() {
        super.viewDidLoad()
        self.view.backgroundColor = .clear
        setup()
        NotificationCenter.default.addObserver(self, selector: #selector(keyBoardShow(_:)), name: UIApplication.keyboardWillShowNotification, object: nil)
        NotificationCenter.default.addObserver(self, selector: #selector(keyBoardHide(_:)), name: UIApplication.keyboardWillHideNotification, object: nil)
    }
    
    var callblock:((String)->Void) = { keyword in}
    
    @objc func keyBoardShow(_ notication:Notification) -> Void {
        guard let info = notication.userInfo,
              let duration = info[UIResponder.keyboardAnimationDurationUserInfoKey] as? TimeInterval,
              let keyboardFrame = info[UIResponder.keyboardFrameEndUserInfoKey] as? CGRect else {
            return
        }
        UIView.animate(withDuration: duration) {
            self.content.snp.updateConstraints { make in
                make.bottom.equalToSuperview().offset(-CGRectGetHeight(keyboardFrame))
            }
            self.view.layoutIfNeeded()
        }
    }
    
    @objc func keyBoardHide(_ notication:Notification) -> Void {
        guard let info = notication.userInfo,
              let duration = info[UIResponder.keyboardAnimationDurationUserInfoKey] as? TimeInterval,
              let keyboardFrame = info[UIResponder.keyboardFrameEndUserInfoKey] as? CGRect else {
            return
        }
        UIView.animate(withDuration: duration) {
            self.content.snp.updateConstraints { make in
                make.bottom.equalToSuperview()
            }
            self.view.layoutIfNeeded()
        }
    }
    
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        DispatchQueue.main.async {
            self.textInput.becomeFirstResponder()
            self.content.cornerCut(radius: 16, corner: [.topLeft,.topRight])
        }
    }
    
    private func setup() -> Void {
        content.snp.makeConstraints { make in
            make.left.right.bottom.equalToSuperview()
        }
        tl.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.top.equalToSuperview().offset(12)
            make.height.equalTo(20)
        }
        textInput.snp.makeConstraints { make in
            make.left.right.equalToSuperview().inset(10)
            make.top.equalTo(tl.snp.bottom).offset(12)
            make.height.equalTo(54)
        }
        saveBtn.snp.makeConstraints { make in
            make.left.right.equalTo(textInput)
            make.top.equalTo(textInput.snp.bottom).offset(12)
            make.height.equalTo(54)
        }
        cancelBtn.snp.makeConstraints { make in
            make.left.right.equalTo(textInput)
            make.top.equalTo(saveBtn.snp.bottom).offset(12)
            make.height.equalTo(54)
            make.bottom.equalToSuperview().offset(-10)
        }
        self.view.layoutIfNeeded()
    }
    
    @objc func emActions(_ sender:UIButton) {
        view.endEditing(true)
        guard let text:String = self.textInput.text else { return }
        if sender.tag == 10 {
            let save = EmailSaveController()
            save.modalTransitionStyle = .crossDissolve
            save.modalPresentationStyle = .overFullScreen
            self.present(save, animated: true)
            DispatchQueue.main.asyncAfter(deadline: .now()+1.5) {
                save.dismiss(animated: true) {
                    self.callblock(text)
                    self.dismiss(animated: true)
                }
            }
        }else{
            self.callblock("")
            self.dismiss(animated: true)
        }
    }
    
    override func touchesBegan(_ touches: Set<UITouch>, with event: UIEvent?) {
        view.endEditing(true)
    }

    private lazy var tl: UILabel = {
        let l = UILabel()
        l.text = "Add Keyvrord"
        l.font = UIFont.boldSystemFont(ofSize: 14)
        l.textAlignment = .center
        l.textColor = UIColor.colorWithHex(hexStr: "#B3B3B3")
        content.addSubview(l)
        return l
    }()
    
    private lazy var textInput: PMTextField = {
        let t = PMTextField()
        t.contentInsets = UIEdgeInsets(top: 0, left: 15, bottom: 0, right: 15)
        t.placeholder = "Keyvrord"
        t.backgroundColor = .white
        t.Radius = 8
        content.addSubview(t)
        return t
    }()
    
    private lazy var saveBtn: UIButton = {
        let save = UIButton(type: .custom)
        save.backgroundColor = UIColor.colorWithHex(hexStr: "#0082FF")
        save.Radius = 8
        save.setTitle("Save", for: .normal)
        save.setTitleColor(.white, for: .normal)
        save.titleLabel?.font = UIFont.boldSystemFont(ofSize: 16)
        save.tag = 10;
        save.addTarget(self, action: #selector(emActions(_:)), for: .touchUpInside)
        content.addSubview(save)
        return save
    }()
    
    private lazy var cancelBtn: UIButton = {
        let save = UIButton(type: .custom)
        save.backgroundColor = .clear
        save.Radius = 8
        save.tag = 11;
        save.setTitle("Cancel", for: .normal)
        save.setTitleColor(UIColor.colorWithHex(hexStr: "#666666"), for: .normal)
        save.titleLabel?.font = UIFont.boldSystemFont(ofSize: 16)
        save.addTarget(self, action: #selector(emActions(_:)), for: .touchUpInside)
        content.addSubview(save)
        return save
    }()
    
    private lazy var content: UIView = {
        let c = UIView()
        c.backgroundColor = UIColor.colorWithHex(hexStr: "#F2F6FC")
        view.addSubview(c)
        return c
    }()
    
    deinit {
        NotificationCenter.default.removeObserver(self)
    }
}
